##
# $Id: beef_bind-handler.rb 121018 Ty Miller @ Threat Intelligence$
##

module Msf
  module Handler
    ###
    #
    # This module implements the Bind TCP handler placeholder only.
    #
    ###
    module BeefBind
      include Msf::Handler

      #
      # Returns the handler specific string representation
      #
      def self.handler_type
        'beef_bind'
      end

      #
      # Returns the connection oriented general handler type
      #
      def self.general_handler_type
        'bind'
      end

      #
      # Initializes a bind handler and adds the options common to all bind
      # payloads, such as local port.
      #
      def initialize(info = {})
        super
        register_options(
          [
            Opt::LPORT(4444)
            # OptAddress.new('RHOST', [false, 'The target address', '']),
          ], Msf::Handler::BeefBind
        )
      end

      #
      # Placeholder only
      #
      def cleanup_handler; end

      #
      # Placeholder only
      #
      def add_handler(_opts = {})
        # Start a new handler
        start_handler
      end

      #
      # Placeholder only
      #
      def start_handler; end

      #
      # Placeholder only
      #
      def stop_handler; end
    end
  end
end
