/*
 Copyright (©) 2003-2025 Teus Benschop.
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


var embedded_classnames = [];


// Creates CSS for embedded character styles.
function css4embeddedstyles ()
{
  var spans = document.querySelectorAll (".ql-editor span");
  spans.forEach((element) => {
    var classname = element.className;
    if (classname) {
      var index = classname.indexOf ("0");
      if (index > 0) {
        if (!embedded_classnames.includes(classname)) {
          embedded_classnames.push (classname);
          var name = classname.substring (2);
          var bits = name.split ("0");
          var font_style = null;
          var font_weight = null;
          var font_variant = null;
          // var font_size = null;
          var text_decoration = null;
          var vertical_align = null;
          var color = null;
          var background_color = null;
          for (i = 0; i < bits.length; i++) {
            name = bits [i];
            var element = document.createElement("span");
            element.className = name;
            document.body.appendChild (element);
            var properties = window.getComputedStyle (element, null);
            var value = properties.getPropertyValue ("font-style");
            if (value != "normal") font_style = value;
            value = properties.getPropertyValue ("font-weight");
            if (value != "normal") font_weight = value;
            value = properties.getPropertyValue ("font-variant");
            if (value != "normal") font_variant = value;
            // The font-size is calculated in "px", and is not very important, so is left out.
            // value = properties.getPropertyValue ("font-size");
            // if (value != "12px") font_size = value;
            value = properties.getPropertyValue ("text-decoration");
            if (value != "none") text_decoration = value;
            value = properties.getPropertyValue ("vertical-align");
            if (value != "baseline") vertical_align = value;
            value = properties.getPropertyValue ("color");
            if (value != "rgb(0, 0, 0)") color = value;
            value = properties.getPropertyValue ("background-color");
            if (value != "rgba(0, 0, 0, 0)") background_color = value;
          }
          var stylesheet = document.styleSheets[0];
          var rule = "." + classname + " { ";
          if (font_style) rule += "font-style: " + font_style + " ; ";
          if (font_weight) rule += "font-weight: " + font_weight + " ; ";
          if (font_variant) rule += "font-variant: " + font_variant + " ; ";
          //if (font_size) rule += "font-size: " + font_size + " ; ";
          if (text_decoration) rule += "text-decoration: " + text_decoration + " ; ";
          if (vertical_align) rule += "vertical-align: " + vertical_align + " ; ";
          if (color) rule += "color: " + color + " ; ";
          if (background_color) rule += "background-color: " + background_color + " ; ";
          rule += " }";
          stylesheet.insertRule(rule);
        }
      }
    }
  });
}


// Returns the character style to apply based on the actual and desired style.
function editor_determine_character_style (actual, desired)
{
  // Deal with undefined actual style.
  if (!actual) actual = "";
  
  // In most cases there's no embedded styles, so deal with that here.
  // If the style was already applied, remove it.
  // If the style was not applied, apply it.
  if (actual == "")
    return desired;
  if (actual == desired)
    return "";
  
  // From now on there are embedded styles, put those in a list.
  var list = actual.split("0");

  // If the desired style is already applied, remove it.
  // If the desired style is not yet there, add it.
  if (list.includes(desired)) {
    list.splice(list.indexOf(desired), 1);
  } else {
    list.push(desired);
  }

  // The new, possibly combined, style.
  var style = list.join("0");
  return style;
}


function post_embedded_style_application (style)
{
  if (style.indexOf ("0") >= 0) css4embeddedstyles ();
}
