# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.16.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Scheduler
  #
  # A service client - single point of access to the REST API.
  #
  class SchedulerManagementClient < MsRestAzure::AzureServiceClient
    include Azure::ARM::Scheduler::Models
    include MsRestAzure

    # @return job_collections
    attr_reader :job_collections

    #
    # Creates initializes a new instance of the SchedulerManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'credentials is nil' if credentials.nil?
      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials)
      @credentials = credentials

      @job_collections = JobCollections.new(self)
      @jobs = Jobs.new(self)
      @api_version = '2016-01-01'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
      if MacOS.version >= :mavericks
        version = `#{MAVERICKS_PKG_PATH}/usr/bin/clang --version`
      else
        version = `/usr/bin/clang --version`
      end
      version = version[/clang-(\d+\.\d+\.\d+(\.\d+)?)/, 1] || "0"
      version < latest_version
    end

  end
end