/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreCreateSchemaDialog
extends BaseDialog {
    private final PostgreSchema schema;
    private List<PostgreRole> allUsers;
    private String name;
    private PostgreRole owner;

    public PostgreCreateSchemaDialog(Shell parentShell, PostgreSchema schema) {
        super(parentShell, PostgreMessages.dialog_create_schema_title, null);
        this.schema = schema;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_schema_name, (String)"");
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PostgreCreateSchemaDialog.this.name = nameText.getText().trim();
                PostgreCreateSchemaDialog.this.getButton(0).setEnabled(!PostgreCreateSchemaDialog.this.name.isEmpty());
            }
        });
        UIUtils.createLabelText((Composite)group, (String)"Database", (String)this.schema.getDatabase().getName(), (int)2056);
        final Combo userCombo = UIUtils.createLabelCombo((Composite)group, (String)PostgreMessages.dialog_create_schema_owner, (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateSchemaDialog.this.owner = PostgreCreateSchemaDialog.this.allUsers.get(userCombo.getSelectionIndex());
            }
        });
        new AbstractJob("Load users"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    new ArrayList();
                    PostgreCreateSchemaDialog.this.allUsers = new ArrayList<PostgreRole>(PostgreCreateSchemaDialog.this.schema.getDatabase().getUsers(monitor));
                    String currentUserName = PostgreCreateSchemaDialog.this.schema.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getUserName();
                    String defUserName = CommonUtils.isEmpty((String)currentUserName) ? "" : currentUserName;
                    UIUtils.syncExec(() -> {
                        for (PostgreRole authId : PostgreCreateSchemaDialog.this.allUsers) {
                            String name = authId.getName();
                            userCombo.add(name);
                            if (!name.equals(defUserName)) continue;
                            PostgreCreateSchemaDialog.this.owner = authId;
                        }
                        userCombo.setText(defUserName);
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

