/*
 * Decompiled with CFR 0.152.
 */
package burp.faraday;

import burp.faraday.FaradayServerAPI;
import burp.faraday.Workspace;
import burp.faraday.exceptions.CookieExpiredException;
import burp.faraday.exceptions.InvalidCredentialsException;
import burp.faraday.exceptions.InvalidFaradayServerException;
import burp.faraday.exceptions.ObjectNotCreatedException;
import burp.faraday.exceptions.SecondFactorRequiredException;
import burp.faraday.exceptions.ServerTooOldException;
import burp.faraday.exceptions.http.ConflictException;
import burp.faraday.exceptions.http.UnauthorizedException;
import burp.faraday.models.requests.SecondFactor;
import burp.faraday.models.requests.User;
import burp.faraday.models.responses.CreatedObjectEntity;
import burp.faraday.models.responses.ExistingObjectEntity;
import burp.faraday.models.responses.LoginStatus;
import burp.faraday.models.responses.ServerInfo;
import burp.faraday.models.vulnerability.Service;
import burp.faraday.models.vulnerability.Vulnerability;
import com.github.zafarkhaja.semver.Version;
import feign.Feign;
import feign.FeignException;
import feign.Logger;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FaradayConnector {
    private static final Version MINIMUM_VERSION = Version.valueOf("3.4.0");
    private final PrintWriter stdout;
    private FaradayServerAPI faradayServerAPI;
    private String baseUrl = null;
    private boolean urlIsValid = false;
    private Workspace currentWorkspace = null;
    private static final CookieManager COOKIE_MANAGER = new CookieManager();

    public FaradayConnector(PrintWriter stdout) {
        this.stdout = stdout;
    }

    public void setBaseUrl(String baseUrl) {
        GsonDecoder decoder = new GsonDecoder();
        this.faradayServerAPI = Feign.builder().logLevel(Logger.Level.FULL).requestInterceptor(this::addCookies).encoder(new GsonEncoder()).errorDecoder(new FaradayErrorDecoder(decoder)).mapAndDecode((response, type) -> {
            this.handleCookies(response.headers());
            return response;
        }, decoder).target(FaradayServerAPI.class, baseUrl);
        this.baseUrl = baseUrl;
        this.urlIsValid = false;
    }

    private void addCookies(RequestTemplate template) {
        URI uri = URI.create(this.baseUrl);
        COOKIE_MANAGER.getCookieStore().get(uri).stream().map(HttpCookie::toString).forEach(cookie -> template.header("Cookie", (String)cookie));
    }

    private void handleCookies(Map<String, Collection<String>> headers) {
        Map<String, List<String>> h = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
        try {
            URI uri = URI.create(this.baseUrl);
            COOKIE_MANAGER.put(uri, h);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Version parseVersion(String version) {
        if (version.split("\\.").length == 2) {
            version = version + ".0";
        }
        return Version.valueOf(version);
    }

    public void validateFaradayURL() throws ServerTooOldException, InvalidFaradayServerException {
        Version serverVersion;
        ServerInfo serverInfo;
        try {
            serverInfo = this.faradayServerAPI.getInfo();
        }
        catch (FeignException e) {
            throw new InvalidFaradayServerException();
        }
        if (serverInfo.getVersion().contains("-")) {
            String[] versionParts = serverInfo.getVersion().split("-");
            serverVersion = this.parseVersion(versionParts[1]);
        } else {
            serverVersion = this.parseVersion(serverInfo.getVersion());
        }
        this.log("Faraday Server version: " + serverVersion.toString());
        if (serverVersion.lessThan(MINIMUM_VERSION)) {
            this.log("Faraday server is too old to be used with this extension. Please upgrade to the latest version.");
            throw new ServerTooOldException();
        }
        this.urlIsValid = true;
        this.log("Faraday server found!");
    }

    public void login(String username, String password) throws InvalidFaradayServerException, InvalidCredentialsException, SecondFactorRequiredException {
        LoginStatus loginStatus;
        if (!this.urlIsValid) {
            throw new InvalidFaradayServerException();
        }
        FaradayConnector.clearCookies();
        User user = new User(username, password);
        try {
            loginStatus = this.faradayServerAPI.login(user);
        }
        catch (UnauthorizedException e) {
            this.log("Invalid credentials.");
            throw new InvalidCredentialsException();
        }
        if (loginStatus.getCode() == 202) {
            this.log("2FA token is required.");
            throw new SecondFactorRequiredException();
        }
        assert (loginStatus.getCode() == 200);
        try {
            this.getSession();
        }
        catch (CookieExpiredException cookieExpiredException) {
            // empty catch block
        }
    }

    void verify2FAToken(String token) throws InvalidFaradayServerException, InvalidCredentialsException {
        LoginStatus loginStatus;
        if (!this.urlIsValid) {
            throw new InvalidFaradayServerException();
        }
        try {
            loginStatus = this.faradayServerAPI.verifyToken(new SecondFactor(token));
        }
        catch (UnauthorizedException e) {
            this.log("Invalid credentials.");
            throw new InvalidCredentialsException();
        }
        assert (loginStatus.getCode() == 200);
        try {
            this.getSession();
        }
        catch (CookieExpiredException cookieExpiredException) {
            // empty catch block
        }
    }

    private void getSession() throws CookieExpiredException {
        this.log("Fetching session info");
        try {
            this.faradayServerAPI.getSession();
        }
        catch (UnauthorizedException e) {
            this.log("The cookie has expired.");
            throw new CookieExpiredException();
        }
        this.log("Session set.");
    }

    List<Workspace> getWorkspaces() throws InvalidFaradayServerException, CookieExpiredException {
        if (!this.urlIsValid) {
            throw new InvalidFaradayServerException();
        }
        this.log("Fetching workspaces");
        try {
            return this.faradayServerAPI.getWorkspaces();
        }
        catch (UnauthorizedException e) {
            throw new CookieExpiredException();
        }
    }

    public void logout() {
        this.log("Logging out");
        this.faradayServerAPI = null;
        this.urlIsValid = false;
    }

    private void log(String msg) {
        this.stdout.println("[CONNECTOR] " + msg);
    }

    public Workspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    void setCurrentWorkspace(Workspace currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }

    void addVulnerabilityToWorkspace(Vulnerability vulnerability, Workspace workspace) throws InvalidFaradayServerException, ObjectNotCreatedException {
        if (!this.urlIsValid) {
            throw new InvalidFaradayServerException();
        }
        try {
            CreatedObjectEntity serviceEntity;
            CreatedObjectEntity hostEntity;
            try {
                hostEntity = this.faradayServerAPI.createHost(workspace.getName(), vulnerability.getHost());
            }
            catch (ConflictException e) {
                hostEntity = e.getExistingObject().getObject();
            }
            Service service = vulnerability.getService();
            service.setParent(hostEntity.getId());
            try {
                serviceEntity = this.faradayServerAPI.createService(workspace.getName(), service);
            }
            catch (ConflictException e) {
                serviceEntity = e.getExistingObject().getObject();
            }
            vulnerability.setParent(serviceEntity.getId());
            CreatedObjectEntity vulnerabilityEntity = this.faradayServerAPI.createVulnerability(workspace.getName(), vulnerability);
            this.log("Created vulnerability " + vulnerabilityEntity.getId());
        }
        catch (UnauthorizedException e) {
            throw new ObjectNotCreatedException();
        }
    }

    static void clearCookies() {
        COOKIE_MANAGER.getCookieStore().removeAll();
    }

    static class FaradayErrorDecoder
    implements ErrorDecoder {
        final Decoder decoder;
        final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();

        FaradayErrorDecoder(Decoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public Exception decode(String methodKey, Response response) {
            try {
                switch (response.status()) {
                    case 401: {
                        return new UnauthorizedException();
                    }
                    case 409: {
                        ExistingObjectEntity existingObject = (ExistingObjectEntity)this.decoder.decode(response, (Type)((Object)ExistingObjectEntity.class));
                        return new ConflictException(existingObject);
                    }
                }
                return FeignException.errorStatus(methodKey, response);
            }
            catch (IOException fallbackToDefault) {
                return this.defaultDecoder.decode(methodKey, response);
            }
        }
    }
}

