# Hantze Wendt orientable dim=7
# [MR]


HWO7Mat := [];

# (2,2,2,2,2,2,2)
HWO7Mat[1] := [
[1, 0, 0, 0, 0, 0, 1],
[1, 1, 0, 0, 0, 0, 0],
[0, 1, 1, 0, 0, 0, 0],
[0, 0, 1, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[2] := [
[1, 0, 0, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 1],
[0, 1, 1, 0, 0, 0, 0],
[0, 0, 1, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];

# (4,2,2,2,2,2,2)
HWO7Mat[3] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 1],
[1, 0, 0, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[4] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[5] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 0, 0, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 1],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[6] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 0, 0, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[7] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 0, 0, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[8] := [
[1, 0, 0, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 1],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[0, 0, 0, 1, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[9] := [
[1, 0, 0, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 1],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 1, 0, 0],
[0, 0, 0, 1, 0, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[10] := [
[1, 0, 0, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 1],
[1, 0, 1, 0, 1, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 1, 0, 0, 1]
];

# (4,4,2,2,2,2,2)
HWO7Mat[11] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 1],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[12] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[13] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[14] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[15] := [
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 1, 1],
[1, 0, 1, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[16] := [
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 1, 0],
[1, 0, 1, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[17] := [
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 1, 0],
[1, 0, 1, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[18] := [
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 1],
[1, 0, 1, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[19] := [
[1, 1, 0, 0, 1, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 1],
[1, 0, 1, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 0, 0, 1, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[20] := [
[1, 1, 0, 0, 1, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[21] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 1, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[22] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 1, 0, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[23] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 1, 1, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[24] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 1],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[25] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 1, 0, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[26] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[27] := [
[1, 1, 0, 0, 1, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 1],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[28] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 1, 0, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[29] := [
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 0, 0, 1, 0, 0, 0],
[0, 1, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];

# (4,4,4,2,2,2,2)
HWO7Mat[30] := [
[1, 1, 1, 0, 1, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 1, 0],
[0, 1, 1, 0, 1, 0, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[31] := [
[1, 1, 1, 0, 1, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[32] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 1, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[33] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 1, 0, 1]
];
HWO7Mat[34] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 1, 1, 1, 0, 0, 1],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[35] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 1, 1],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[36] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 1, 0],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[37] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 1, 1, 0, 0, 1],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[38] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 1, 0, 1, 1, 0, 0],
[0, 1, 1, 0, 1, 0, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[39] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 1, 0, 0],
[0, 1, 1, 0, 1, 1, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[40] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 1, 0, 0],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[41] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 1, 0, 0],
[0, 1, 1, 0, 1, 0, 1],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 1, 1]
];
HWO7Mat[42] := [
[1, 1, 1, 0, 1, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[43] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 1, 0, 1]
];
HWO7Mat[44] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[1, 1, 0, 1, 0, 0, 1],
[0, 1, 1, 1, 1, 0, 0],
[0, 0, 1, 0, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[45] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 1, 0, 1, 0, 0, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 1, 0, 0, 1, 1]
];
HWO7Mat[46] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 1, 0, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 1, 0, 0, 1, 1]
];
HWO7Mat[47] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 1, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 0, 0, 1, 0, 0, 0],
[0, 1, 1, 0, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 0, 1]
];
HWO7Mat[48] := [
[1, 1, 1, 0, 1, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 1, 0, 0, 0, 1]
];
HWO7Mat[49] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 1, 0, 0, 0, 1, 0],
[0, 0, 1, 0, 1, 0, 1]
];
HWO7Mat[50] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 1, 0],
[1, 0, 1, 0, 0, 0, 1],
[1, 0, 0, 1, 0, 0, 0],
[0, 1, 1, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 0, 1]
];
HWO7Mat[51] := [
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 0, 0, 0, 1, 0],
[1, 0, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 1, 1, 0, 0],
[0, 1, 0, 0, 1, 1, 0],
[0, 0, 1, 0, 0, 0, 1]
];

# (4,4,4,4,2,2,2)
HWO7Mat[52] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 1, 0, 0, 1, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 0, 1, 0],
[0, 0, 0, 1, 1, 0, 1]
];
HWO7Mat[53] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 1, 0],
[0, 1, 0, 0, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 1],
[0, 0, 0, 1, 0, 0, 1]
];
HWO7Mat[54] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 1, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 0, 1, 0, 1, 1]
];
HWO7Mat[55] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 1, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 1, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 0, 1, 0, 0, 1]
];
HWO7Mat[56] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 1, 1, 0, 1, 0, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 1, 0, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 0, 1, 0, 1, 1]
];
HWO7Mat[57] := [
[1, 1, 1, 1, 1, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 0, 0, 1, 0],
[0, 1, 1, 1, 0, 0, 1],
[1, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 1, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[58] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 1, 0],
[0, 1, 0, 1, 0, 0, 1],
[1, 1, 1, 0, 1, 0, 0],
[0, 0, 1, 1, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[59] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 0, 1, 0],
[0, 1, 0, 1, 0, 0, 0],
[1, 1, 1, 0, 1, 0, 1],
[0, 0, 1, 1, 1, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[60] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 1, 0, 0],
[0, 1, 0, 1, 0, 0, 1],
[1, 0, 1, 1, 1, 1, 0],
[0, 1, 1, 0, 0, 1, 0],
[0, 0, 0, 0, 0, 0, 1]
];
HWO7Mat[61] := [
[1, 1, 1, 1, 0, 0, 0],
[1, 1, 0, 0, 0, 0, 0],
[1, 0, 1, 1, 1, 0, 0],
[0, 1, 0, 1, 0, 0, 0],
[1, 0, 1, 1, 1, 1, 0],
[0, 1, 1, 0, 0, 1, 1],
[0, 0, 0, 0, 0, 0, 1]
];

# (4,4,4,4,4,2,2)
HWO7Mat[62] := [
[1, 1, 1, 1, 1, 0, 0],
[1, 1, 1, 0, 0, 0, 0],
[1, 1, 1, 0, 1, 1, 0],
[1, 0, 0, 1, 0, 0, 1],
[0, 1, 0, 1, 1, 0, 0],
[0, 0, 1, 0, 1, 1, 0],
[0, 0, 0, 1, 0, 0, 1]
];


HWO7Gr := [];


for m in HWO7Mat do
  dim := Size(m);
  gc := [];

  for i in [1..dim] do
    # row's version
    gc[i] := -IdentityMat(dim+1);
    gc[i][i][i] := 1;
    gc[i][dim+1][dim+1] := 1;
    gc[i][dim+1]{[1..dim]} := m[i]/2;
    
  od;

  Add(HWO7Gr, AffineCrystGroup(gc));
od;

Unbind(m);
Unbind(dim);
Unbind(gc);
Unbind(i);


