## jwt encode

Encode JWT with JWS and/or JWE

### Synopsis

Encode JWT with JWS and/or JWE

```
jwt encode <stdin>|<jwt> [flags]
```

### Examples

```
- Signing with user-provided key: 
   jwt encode '{...}' --signing-key file:///var/mykey.pem
- Signing with auto-generated RSA 2048-bit key: 
   jwt encode '{...}' --signing-key auto://RS256?bits=2048
- Encrypting with user-provided key and A128GCM encryption algorithm: 
   jwt encode '{...}' --encryption-key file:///var/mykey.pem?enc=A128GCM
- Encrypting with auto-generated EDSCA key with curve P256 and A128GCM encryption algorithm: 
   jwt encode '{...}' --encryption-key auto://ECDH_ES?bits=256&enc=A128GCM
```

### Options

```
      --signing-key string      URL to private key used to sign the JWT
      --encryption-key string   URL to public key used to encrypt the JWT
      --key-id string           Customize key id
  -h, --help                    help for encode
```

### SEE ALSO

* [jwt](jwt.md)	 - A command line program that provides tools for JWT using JWS and JWE

###### Auto generated by spf13/cobra on 29-Oct-2019
