.TH "grub-btrfsd" "8"

.SH "NAME"
.PP
grub-btrfsd - An OpenRC daemon to automatically update the grub menu with
.BR grub-btrfs (8)
.PP
when a new btrfs snapshot is created.

.SH "SYNOPSIS"
.PP
\fCgrub\-btrfsd [\-h, \-\-help] [\-c, \-\-no\-color] [\-l, \-\-log\-file LOG_FILE] [\-s, \-\-syslog] [\-t, \-\-timeshift\-auto] [\-v, \-\-verbose] SNAPSHOTS_DIR\fP

.SH "DESCRIPTION"
.PP
Grub-btrfsd is a shell script which is meant to be run as a daemon.
Grub-btrfsd watches a directory where btrfs-snapshots are created or deleted via inotifywait and runs grub-mkconfig (if grub-mkconfig never ran before since grub-btrfs was installed) or \fC/etc/grub.d/41_snapshots\-btrfs\fP (when grub-mkconfig ran before with grub-btrfs installed) when something in that directory changes.

.SH "OPTIONS"
.SS "\fCSNAPSHOTS_DIR\fP"
.PP
This argument specifies the path where grub-btrfsd looks for newly created snapshots and snapshot deletions. It is usually defined by the program used to make snapshots.
E.g. for Snapper this would be \fC/.snapshots\fP

.SS "\fC\-c / \-\-no\-color\fP"
.PP
Disable colors in output.

.SS "\fC\-l / \-\-log\-file\fP"
.PP
This arguments specifies a file where grub-btrfsd should write log messages.

.SS "\fC\-s / \-\-syslog\fP"
.PP
Write to syslog

.SS "\fC\-t / \-\-timeshift\-auto\fP"
.PP
This is a flag to activate the auto detection of the path where Timeshift stores snapshots. Newer versions (>=22.06) of Timeshift mount their snapshots to \fC/run/timeshift/$PID/backup/timeshift\-btrfs\fP. Where \fC$PID\fP is the process ID of the currently running Timeshift session. The PID is changing every time Timeshift is opened. grub-btrfsd can automatically take care of the detection of the correct PID and directory if this flag is set. In this case the argument \fCSNAPSHOTS_DIR\fP has no effect.

.SS "\fC\-v / \-\-verbose\fP"
.PP
Let the log of the daemon be more verbose

.SS "\fC\-h / \-\-help\fP"
.PP
Displays a short help message.



.SH "CONFIGURATION"
.PP
The daemon is usually configured via the file \fC/etc/conf.d/grub\-btrfsd\fP on openrc-init systems and \fCsudo systemctl edit \-\-full grub\-btrfsd\fP on systemd systems. In this file the arguments (See OPTIONS), that OpenRC passes to the daemon when it is started, can be configured.

.SS "NOTES"
.PP
A common configuration for Snapper would be to set \fCSNAPSHOTS_DIR\fP to \fC/.snapshots\fP and not to set \fC\-\-timeshift\-auto\fP.
For Timeshift \fC\-\-timeshift\-auto\fP is set to true and \fCSNAPSHOTS_DIR\fP can be left as is.

.SH "FILES"
.PP
\fC/etc/conf.d/grub\-btrfsd\fP
\fC/usr/lib/systemd/system/grub\-btrfsd.service\fP

.SH "SEE ALSO"
.IR btrfs (8)
.IR btrfs-subvolume (8)
.IR grub-btrfsd (8)
.IR grub-mkconfig (8)
.IR inotifywait (1)
.IR openrc (8)
.IR rc-service (8)
.IR timeshift (1)

.SH "COPYRIGHT"
.PP
Copyright (c) 2022 Pascal Jäger
