/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.StrategyBlindBin;
import com.jsql.model.injection.strategy.StrategyBlindBit;
import com.jsql.model.injection.strategy.StrategyError;
import com.jsql.model.injection.strategy.StrategyMultibit;
import com.jsql.model.injection.strategy.StrategyStack;
import com.jsql.model.injection.strategy.StrategyTime;
import com.jsql.model.injection.strategy.StrategyUnion;
import com.jsql.model.suspendable.SuspendableGetCharInsertion;
import com.jsql.model.suspendable.SuspendableGetVendor;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediatorStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AbstractStrategy time;
    private final AbstractStrategy blindBit;
    private final AbstractStrategy blindBin;
    private final AbstractStrategy multibit;
    private final StrategyError error;
    private final AbstractStrategy union;
    private final AbstractStrategy stack;
    private final List<AbstractStrategy> strategies;
    private AbstractStrategy strategy;
    private final InjectionModel injectionModel;

    public MediatorStrategy(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.time = new StrategyTime(this.injectionModel);
        this.blindBit = new StrategyBlindBit(this.injectionModel);
        this.blindBin = new StrategyBlindBin(this.injectionModel);
        this.multibit = new StrategyMultibit(this.injectionModel);
        this.error = new StrategyError(this.injectionModel);
        this.union = new StrategyUnion(this.injectionModel);
        this.stack = new StrategyStack(this.injectionModel);
        this.strategies = Arrays.asList(this.time, this.blindBin, this.blindBit, this.multibit, this.error, this.stack, this.union);
    }

    public String getMeta() {
        String strategyName = this.strategy == null ? "" : this.strategy.toString().toLowerCase();
        String strategyMode = "default";
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isDiosStrategy()) {
            strategyMode = "dios";
        } else if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isZipStrategy()) {
            strategyMode = "zip";
        }
        return String.format("%s#%s", strategyName.replace(" ", "-"), strategyMode);
    }

    public String buildPath(String urlBase, boolean isUsingIndex, String sqlTrail) {
        String result = urlBase;
        if (urlBase.contains("*")) {
            result = !isUsingIndex ? urlBase.replace("*", this.encodePath(sqlTrail)) : urlBase.replace("*", this.encodePath(this.injectionModel.getIndexesInUrl().replaceAll(String.format("1337%s7331", this.getSpecificUnion().getVisibleIndex()), Matcher.quoteReplacement(sqlTrail))));
        }
        return result;
    }

    private String encodePath(String sqlTrail) {
        String sqlTrailEncoded = StringUtil.cleanSql(sqlTrail);
        if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isUrlEncodingDisabled()) {
            sqlTrailEncoded = sqlTrailEncoded.replace("'", "%27").replace("(", "%28").replace(")", "%29").replace("{", "%7b").replace("[", "%5b").replace("]", "%5d").replace("}", "%7d").replace(">", "%3e").replace("<", "%3c").replace("?", "%3f").replace("_", "%5f").replace("\\", "%5c").replace(",", "%2c");
        }
        return (sqlTrailEncoded + this.injectionModel.getMediatorVendor().getVendor().instance().endingComment()).replace("\"", "%22").replace("|", "%7c").replace("`", "%60").replace(" ", "%20").replace("+", "%20");
    }

    public boolean testStrategies(AbstractMap.SimpleEntry<String, String> parameterToInject) throws JSqlException {
        String parameterOriginalValue = null;
        this.injectionModel.getMediatorVendor().setVendor(this.injectionModel.getMediatorVendor().fingerprintVendor());
        if (parameterToInject != null) {
            String characterInsertion;
            parameterOriginalValue = parameterToInject.getValue();
            String characterInsertionByUser = this.injectionModel.getMediatorUtils().getParameterUtil().initStar(parameterToInject);
            String string = characterInsertion = this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotSearchingCharInsertion() ? characterInsertionByUser : new SuspendableGetCharInsertion(this.injectionModel).run(characterInsertionByUser);
            if (characterInsertion.contains("*")) {
                parameterToInject.setValue(characterInsertion);
            } else {
                parameterToInject.setValue(characterInsertion.replaceAll("(\\w)$", "$1+") + "*");
            }
        } else if (this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().contains("*")) {
            String characterInsertion = new SuspendableGetCharInsertion(this.injectionModel).run("");
            String urlBase = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
            this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlBase(urlBase.replace("*", characterInsertion.replaceAll("(\\w)$", "$1%20") + "*"));
        }
        if (this.injectionModel.getMediatorVendor().getVendorByUser() == this.injectionModel.getMediatorVendor().getAuto()) {
            new SuspendableGetVendor(this.injectionModel).run(new Object[0]);
        }
        this.time.checkApplicability();
        this.blindBin.checkApplicability();
        this.blindBit.checkApplicability();
        if (parameterToInject != null) {
            String backupCharacterInsertion = parameterToInject.getValue();
            parameterToInject.setValue("*");
            this.multibit.checkApplicability();
            parameterToInject.setValue(backupCharacterInsertion);
        } else {
            this.multibit.checkApplicability();
        }
        this.error.checkApplicability();
        this.stack.checkApplicability();
        this.union.checkApplicability();
        this.union.activateWhenApplicable();
        this.stack.activateWhenApplicable();
        this.error.activateWhenApplicable();
        this.multibit.activateWhenApplicable();
        this.blindBit.activateWhenApplicable();
        this.blindBin.activateWhenApplicable();
        this.time.activateWhenApplicable();
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null) {
            if (parameterOriginalValue != null) {
                parameterToInject.setValue(parameterOriginalValue.replace("*", ""));
            }
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "No injection found");
            return false;
        }
        return true;
    }

    public AbstractStrategy getUnion() {
        return this.union;
    }

    public StrategyUnion getSpecificUnion() {
        return (StrategyUnion)this.union;
    }

    public StrategyError getError() {
        return this.error;
    }

    public AbstractStrategy getBlindBit() {
        return this.blindBit;
    }

    public AbstractStrategy getBlindBin() {
        return this.blindBin;
    }

    public AbstractStrategy getMultibit() {
        return this.multibit;
    }

    public AbstractStrategy getTime() {
        return this.time;
    }

    public AbstractStrategy getStack() {
        return this.stack;
    }

    public List<AbstractStrategy> getStrategies() {
        return this.strategies;
    }

    public AbstractStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AbstractStrategy strategy) {
        this.strategy = strategy;
    }
}

