---
title: Release 0.53.0
short-description: Release notes for 0.53.0
...

# New features

## A new module for filesystem operations

The new `fs` module can be used to examine the contents of the current
file system.

```meson
fs = import('fs')
assert(fs.exists('important_file'),
       'The important file is missing.')
```

## meson dist --include-subprojects

`meson dist` command line now gained `--include-subprojects` command
line option. When enabled, the source tree of all subprojects used by
the current build will also be included in the final tarball. This is
useful to distribute self contained tarball that can be built offline
(i.e. `--wrap-mode=nodownload`).

## Added new Meson templates for `Dlang`, `Rust`, `Objective-C`

Meson now ships with predefined project templates for `Dlang`,
`Fortran`, `Rust`, `Objective-C`, and by passing the associated flags `d`,
`fortran`, `rust`, `objc` to `meson init --language`.

## Add a new summary() function

A new function [[summary]] has been
added to summarize build configuration at the end of the build
process.

Example:
```meson
project('My Project', version : '1.0')
summary({'bindir': get_option('bindir'),
         'libdir': get_option('libdir'),
         'datadir': get_option('datadir'),
        }, section: 'Directories')
summary({'Some boolean': false,
         'Another boolean': true,
         'Some string': 'Hello World',
         'A list': ['string', 1, true],
        }, section: 'Configuration')
```

Output:
```
My Project 1.0

  Directories
             prefix: /opt/gnome
             bindir: bin
             libdir: lib/x86_64-linux-gnu
            datadir: share

  Configuration
       Some boolean: False
    Another boolean: True
        Some string: Hello World
             A list: string
                     1
                     True
```

## Generic Overrider for Dynamic Linker selection

Previous to Meson 0.52.0 you set the dynamic linker using compiler
specific flags passed via language flags and hoped things worked out.
In version 0.52.0 Meson started detecting the linker and making
intelligent decisions about using it. Unfortunately this broke
choosing a non-default linker.

Now there is a generic mechanism for doing this. In 0.53.0, you can
use the `LD` environment variable. **In 0.53.1** this was changed to
`<compiler_variable>_LD`, such as `CC_LD`, `CXX_LD`, `D_LD`, etc due
to regressions. The usual Meson [environment variable
rules](https://mesonbuild.com/Running-Meson.html#environment-variables)
apply. Alternatively, you can add the following to a cross or native
file:

In 0.53.0:

```ini
[binaries]
ld = 'gold'
```

**In 0.53.1 or newer**:

```ini
[binaries]
c = 'gcc'
c_ld = 'gold'
```

```ini
[binaries]
c = 'clang'
c_ld = 'lld'
```

And Meson will select the linker if possible.

## `fortran_std` option

**new in 0.53.0** Akin to the `c_std` and `cpp_std` options, the
`fortran_std` option sets Fortran compilers to warn or error on
non-Fortran standard code. Only the Gfortran and Intel Fortran
compilers have support for this option. Other Fortran compilers ignore
the `fortran_std` option.

Supported values for `fortran_std` include:

* `legacy` for non-conforming code--this is especially important for Gfortran, which by default errors on old non-compliant Fortran code
* `f95` for Fortran 95 compliant code.
* `f2003` for Fortran 2003 compliant code.
* `f2008` for Fortran 2008 compliant code.
* `f2018` for Fortran 2018 compliant code.

## python.dependency() embed kwarg

Added the `embed` kwarg to the python module dependency function to
select the python library that can be used to embed python into an
application.

## Scalapack

added in **0.53.0**:

```meson
scalapack = dependency('scalapack')
```

Historically and through today, typical Scalapack setups have broken
and incomplete pkg-config or FindScalapack.cmake. Meson handles
finding Scalapack on setups including:

* Linux: Intel MKL or OpenMPI + Netlib
* MacOS: Intel MKL or OpenMPI + Netlib
* Windows: Intel MKL (OpenMPI not available on Windows)

## Search directories for `find_program()`

It is now possible to give a list of absolute paths where `find_program()` should
also search, using the `dirs` keyword argument.

For example on Linux `/sbin` and `/usr/sbin` are not always in the `$PATH`:
```meson
prog = find_program('mytool', dirs : ['/usr/sbin', '/sbin'])
```

## Source tags targets

When the respective tools are available, 'ctags', 'TAGS' and 'cscope'
targets will be generated by Meson, unless you have defined your own.

## Dictionary entry using string variable as key

Keys can now be any expression evaluating to a string value, not limited
to string literals any more.
```meson
d = {'a' + 'b' : 42}
k = 'cd'
d += {k : 43}
```

## Improved CMake subprojects support

With this release even more CMake projects are supported via [CMake
subprojects](CMake-module.md#cmake-subprojects) due to these internal
improvements:

- Use the CMake file API for CMake >=3.14
- Handle the explicit dependencies via `add_dependency`
- Basic support for `add_custom_target`
- Improved `add_custom_command` support
- Object library support on Windows

## compiler.get_linker_id()

since 0.53.0, `compiler.get_linker_id()` allows retrieving a lowercase
name for the linker. Since each compiler family can typically use a
variety of linkers depending on operating system, this helps users
define logic for corner cases not otherwise easily handled.

## CUDA dependency

Native support for compiling and linking against the CUDA Toolkit
using the `dependency` function:

```meson
project('CUDA test', 'cpp', meson_version: '>= 0.53.0')
exe = executable('prog', 'prog.cc', dependencies: dependency('cuda'))
```

See [the CUDA dependency](Dependencies.md#cuda) for more information.

## Added global option to disable C++ RTTI

The new boolean option is called `cpp_rtti`.

## Introspection API changes

dependencies (--dependencies, intro-dependencies.json):
- added the `version` key

scanning dependencies (--scan-dependencies):
- added the `version` key containing the required dependency version

tests and benchmarks (--tests, --benchmarks, intro-tests.json,
intro-benchmarks.json):
- added the `protocol` key
