/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import io.netty.channel.ChannelHandler;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.runtime.DefaultBoltConnection;
import org.neo4j.bolt.runtime.scheduling.BoltConnectionQueueMonitorAggregate;
import org.neo4j.bolt.runtime.scheduling.BoltConnectionReadLimiter;
import org.neo4j.bolt.runtime.scheduling.BoltScheduler;
import org.neo4j.bolt.runtime.scheduling.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.transport.pipeline.KeepAliveHandler;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;

public class DefaultBoltConnectionFactory
implements BoltConnectionFactory {
    private final BoltSchedulerProvider schedulerProvider;
    private final LogService logService;
    private final Clock clock;
    private final Config config;
    private final BoltConnectionMetricsMonitor metricsMonitor;

    public DefaultBoltConnectionFactory(BoltSchedulerProvider schedulerProvider, Config config, LogService logService, Clock clock, Monitors monitors) {
        this.schedulerProvider = schedulerProvider;
        this.config = config;
        this.logService = logService;
        this.clock = clock;
        this.metricsMonitor = (BoltConnectionMetricsMonitor)monitors.newMonitor(BoltConnectionMetricsMonitor.class, new String[0]);
    }

    @Override
    public BoltConnection newConnection(BoltChannel channel, BoltStateMachine stateMachine, BoltResponseMessageWriter messageWriter) {
        Objects.requireNonNull(channel);
        Objects.requireNonNull(stateMachine);
        BoltScheduler scheduler = this.schedulerProvider.get(channel);
        BoltConnectionReadLimiter readLimiter = DefaultBoltConnectionFactory.createReadLimiter(this.config, this.logService);
        BoltConnectionQueueMonitorAggregate connectionQueueMonitor = new BoltConnectionQueueMonitorAggregate(scheduler, readLimiter);
        KeepAliveHandler keepAliveHandler = DefaultBoltConnectionFactory.createKeepAliveHandler(this.config, messageWriter);
        if (keepAliveHandler != null) {
            channel.rawChannel().pipeline().addLast(new ChannelHandler[]{keepAliveHandler});
        }
        DefaultBoltConnection connection = new DefaultBoltConnection(channel, messageWriter, stateMachine, this.logService, scheduler, connectionQueueMonitor, DefaultBoltConnection.DEFAULT_MAX_BATCH_SIZE, keepAliveHandler, this.metricsMonitor, this.clock);
        connection.start();
        return connection;
    }

    private static BoltConnectionReadLimiter createReadLimiter(Config config, LogService logService) {
        int lowWatermark = (Integer)config.get(GraphDatabaseInternalSettings.bolt_inbound_message_throttle_low_water_mark);
        int highWatermark = (Integer)config.get(GraphDatabaseInternalSettings.bolt_inbound_message_throttle_high_water_mark);
        return new BoltConnectionReadLimiter(logService, lowWatermark, highWatermark);
    }

    private static KeepAliveHandler createKeepAliveHandler(Config config, BoltResponseMessageWriter messageWriter) {
        BoltConnector.KeepAliveRequestType mechanism = (BoltConnector.KeepAliveRequestType)config.get(BoltConnector.connection_keep_alive_type);
        if (mechanism != BoltConnector.KeepAliveRequestType.ALL) {
            return null;
        }
        long interval = ((Duration)config.get(BoltConnector.connection_keep_alive)).toMillis();
        return new KeepAliveHandler(interval, messageWriter);
    }
}

