/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.util.UUID;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.messaging.request.TransactionInitiatingMessage;
import org.neo4j.bolt.v4.messaging.BeginMessage;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
extends org.neo4j.bolt.v3.runtime.ReadyState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof org.neo4j.bolt.v4.messaging.RunMessage || message instanceof BeginMessage) {
            return super.processUnsafe(message, context);
        }
        return null;
    }

    private String extractDatabaseName(TransactionInitiatingMessage message) {
        if (message instanceof org.neo4j.bolt.v4.messaging.RunMessage) {
            return ((org.neo4j.bolt.v4.messaging.RunMessage)message).databaseName();
        }
        if (message instanceof BeginMessage) {
            return ((BeginMessage)message).databaseName();
        }
        throw new IllegalStateException("Expected either a BoltV4 RUN message or BEGIN message, but got: " + message.getClass());
    }

    @Override
    protected BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        long start = context.clock().millis();
        String programId = UUID.randomUUID().toString();
        context.connectionState().setCurrentTransactionId(programId);
        ProgramResultReference runResult = context.getTransactionManager().runProgram(programId, context.getLoginContext(), this.extractDatabaseName(message), message.statement(), message.params(), message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), context.connectionId());
        long end = context.clock().millis();
        context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])runResult.statementMetadata().fieldNames()));
        context.connectionState().onMetadata("t_first", (AnyValue)Values.longValue((long)(end - start)));
        return this.streamingState;
    }

    @Override
    protected BoltStateMachineState processBeginMessage(org.neo4j.bolt.v3.messaging.request.BeginMessage message, StateMachineContext context) throws Exception {
        String transactionId = context.getTransactionManager().begin(context.getLoginContext(), this.extractDatabaseName(message), message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), context.connectionId());
        context.connectionState().setCurrentTransactionId(transactionId);
        return this.txReadyState;
    }
}

