/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormats;

public class ImportMemoryCalculator {
    public static long estimatedStoreSize(Input.Estimates estimates, RecordFormats recordFormats) {
        long nodeSize = estimates.numberOfNodes() * (long)recordFormats.node().getRecordSize(NoStoreHeader.NO_STORE_HEADER);
        long relationshipSize = estimates.numberOfRelationships() * (long)recordFormats.relationship().getRecordSize(NoStoreHeader.NO_STORE_HEADER);
        long propertySize = estimates.sizeOfNodeProperties() + estimates.sizeOfRelationshipProperties();
        long tempIdPropertySize = estimates.numberOfNodes() * (long)recordFormats.property().getRecordSize(NoStoreHeader.NO_STORE_HEADER);
        return ImportMemoryCalculator.defensivelyPadMemoryEstimate(nodeSize + relationshipSize + propertySize + tempIdPropertySize);
    }

    public static long estimatedCacheSize(MemoryStatsVisitor.Visitable baseMemory, MemoryStatsVisitor.Visitable ... memoryUsers) {
        long neoStoreSize = GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])new MemoryStatsVisitor.Visitable[]{baseMemory});
        long importCacheSize = GatheringMemoryStatsVisitor.highestMemoryUsageOf((MemoryStatsVisitor.Visitable[])memoryUsers);
        return neoStoreSize + ImportMemoryCalculator.defensivelyPadMemoryEstimate(importCacheSize);
    }

    public static long optimalMinimalHeapSize(Input.Estimates estimates, RecordFormats recordFormats) {
        long estimatedStoreSize = ImportMemoryCalculator.estimatedStoreSize(estimates, recordFormats);
        return ByteUnit.gibiBytes((long)1L) + estimatedStoreSize / 2000L;
    }

    public static long defensivelyPadMemoryEstimate(long bytes) {
        return (long)((double)bytes * 1.1);
    }

    public static long defensivelyPadMemoryEstimate(MemoryStatsVisitor.Visitable ... memoryUsers) {
        return ImportMemoryCalculator.defensivelyPadMemoryEstimate(GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])memoryUsers));
    }
}

