/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ProcessContext;
import org.neo4j.internal.batchimport.staging.PullingProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class ReadGroupsFromCacheStep
extends PullingProducerStep<ProcessContext> {
    private final int itemSize;
    private final PrefetchingIterator<RelationshipGroupRecord> data;
    private RelationshipGroupRecord[] scratch;
    private int cursor;

    public ReadGroupsFromCacheStep(StageControl control, Configuration config, Iterator<RelationshipGroupRecord> groups, int itemSize) {
        super(control, config);
        this.data = Iterators.prefetching(groups);
        this.itemSize = itemSize;
        this.scratch = new RelationshipGroupRecord[config.batchSize() * 2];
    }

    protected Object nextBatchOrNull(long ticket, int batchSize, ProcessContext processContext) {
        if (!this.data.hasNext()) {
            return null;
        }
        int i = 0;
        long lastOwner = -1L;
        while (this.data.hasNext()) {
            RelationshipGroupRecord item = (RelationshipGroupRecord)this.data.peek();
            if (i == batchSize - 1) {
                lastOwner = item.getOwningNode();
            } else if (i >= batchSize && item.getOwningNode() != lastOwner) break;
            if (i >= this.scratch.length) {
                this.scratch = Arrays.copyOf(this.scratch, this.scratch.length * 2);
            }
            this.scratch[i] = (RelationshipGroupRecord)this.data.next();
            ++this.cursor;
            ++i;
        }
        return Arrays.copyOf(this.scratch, i);
    }

    protected long position() {
        return this.cursor * this.itemSize;
    }
}

