/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RecordStore;

public class StoreIdIterator
implements LongIterator {
    private final RecordStore<?> store;
    private long targetId;
    private long id;
    private final boolean forward;

    public StoreIdIterator(RecordStore<?> store, boolean forward, CursorContext cursorContext) {
        this(store, forward, forward ? (long)store.getNumberOfReservedLowIds() : store.getHighestPossibleIdInUse(cursorContext));
    }

    public StoreIdIterator(RecordStore<?> store, boolean forward, long initialId) {
        this.store = store;
        this.id = initialId;
        this.forward = forward;
    }

    public String toString() {
        return String.format("%s[id=%s/%s; store=%s]", this.getClass().getSimpleName(), this.id, this.targetId, this.store);
    }

    public boolean hasNext() {
        if (this.forward) {
            if (this.id < this.targetId) {
                return true;
            }
            this.targetId = this.store.getHighId();
            return this.id < this.targetId;
        }
        return this.id > 0L;
    }

    public long next() {
        long l;
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.forward ? String.format("ID [%s] has exceeded the high ID [%s] of %s.", this.id, this.targetId, this.store) : String.format("ID [%s] has exceeded the low ID [%s] of %s.", this.id, this.targetId, this.store));
        }
        try {
            l = this.id;
            this.id += this.forward ? 1L : -1L;
        }
        catch (Throwable throwable) {
            this.id += this.forward ? 1L : -1L;
            throw throwable;
        }
        return l;
    }
}

