/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.HeapEstimator;

public class PropertyKeyTokenRecord
extends TokenRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PropertyKeyTokenRecord.class);
    private int propCount;

    public PropertyKeyTokenRecord(int id) {
        super(id);
    }

    public PropertyKeyTokenRecord(PropertyKeyTokenRecord other) {
        super(other);
        this.propCount = other.propCount;
    }

    public PropertyKeyTokenRecord initialize(boolean inUse, int nameId, int propertyCount) {
        super.initialize(inUse, nameId);
        this.propCount = propertyCount;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.propCount = 0;
    }

    @Override
    protected String simpleName() {
        return "PropertyKey";
    }

    public int getPropertyCount() {
        return this.propCount;
    }

    public void setPropertyCount(int count) {
        this.propCount = count;
    }

    @Override
    protected void additionalToString(StringBuilder buf) {
        buf.append(",propCount=").append(this.propCount);
    }

    @Override
    public PropertyKeyTokenRecord copy() {
        return new PropertyKeyTokenRecord(this);
    }
}

