/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict, TokenNameLookup tokenNameLookup) {
        this(constraint, phase, Collections.singleton(conflict), tokenNameLookup);
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", (Throwable)UniquePropertyValueValidationException.buildCauseChain(conflicts), tokenNameLookup);
        this.conflicts = conflicts;
    }

    private static IndexEntryConflictException buildCauseChain(Set<IndexEntryConflictException> conflicts) {
        IndexEntryConflictException chainedConflicts = null;
        for (IndexEntryConflictException conflict : conflicts) {
            chainedConflicts = (IndexEntryConflictException)Exceptions.chain(chainedConflicts, (Throwable)conflict);
        }
        return chainedConflicts;
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause, tokenNameLookup);
        this.conflicts = Collections.emptySet();
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = this.constraint.schema();
        StringBuilder message = new StringBuilder();
        Iterator<IndexEntryConflictException> iterator = this.conflicts.iterator();
        while (iterator.hasNext()) {
            IndexEntryConflictException conflict = iterator.next();
            message.append(conflict.evidenceMessage(tokenNameLookup, schema));
            if (!iterator.hasNext()) continue;
            message.append(System.lineSeparator());
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

