/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.token.api.NamedToken;

public abstract class TokenAccess<R> {
    public static final TokenAccess<RelationshipType> RELATIONSHIP_TYPES = new TokenAccess<RelationshipType>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.relationshipTypesGetAllTokens();
        }

        @Override
        RelationshipType token(NamedToken token) {
            return RelationshipType.withName((String)token.name());
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForRelationshipType(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForRelationshipType(tokenId)) || transaction.dataRead().countsForRelationship(-1, tokenId, -1) > 0L;
        }
    };
    public static final TokenAccess<Label> LABELS = new TokenAccess<Label>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.labelsGetAllTokens();
        }

        @Override
        Label token(NamedToken token) {
            return Label.label((String)token.name());
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return TokenAccess.hasAny(schemaReadCore.indexesGetForLabel(tokenId)) || TokenAccess.hasAny(schemaReadCore.constraintsGetForLabel(tokenId)) || transaction.dataRead().countsForNode(tokenId) > 0L;
        }
    };
    public static final TokenAccess<String> PROPERTY_KEYS = new TokenAccess<String>(){

        @Override
        Iterator<NamedToken> tokens(TokenRead read) {
            return read.propertyKeyGetAllTokens();
        }

        @Override
        String token(NamedToken token) {
            return token.name();
        }

        @Override
        boolean inUse(KernelTransaction transaction, SchemaReadCore schemaReadCore, int tokenId) {
            return true;
        }
    };

    private static <T> Iterator<T> inUse(final KernelTransaction transaction, TokenAccess<T> access) {
        final SchemaReadCore schemaReadCore = transaction.schemaRead().snapshot();
        return new TokenIterator<T>(transaction, access){

            protected T fetchNextOrNull() {
                while (this.tokens.hasNext()) {
                    NamedToken token = (NamedToken)this.tokens.next();
                    if (!this.access.inUse(transaction, schemaReadCore, token.id())) continue;
                    return this.access.token(token);
                }
                return null;
            }
        };
    }

    private static <T> Iterator<T> all(KernelTransaction transaction, TokenAccess<T> access) {
        return new TokenIterator<T>(transaction, access){

            protected T fetchNextOrNull() {
                if (this.tokens.hasNext()) {
                    return this.access.token((NamedToken)this.tokens.next());
                }
                return null;
            }
        };
    }

    public final Iterator<R> inUse(KernelTransaction transaction) {
        return TokenAccess.inUse(transaction, this);
    }

    public final Iterator<R> all(KernelTransaction transaction) {
        return TokenAccess.all(transaction, this);
    }

    private static boolean hasAny(Iterator<?> iter) {
        if (iter.hasNext()) {
            return true;
        }
        if (iter instanceof Resource) {
            ((Resource)iter).close();
        }
        return false;
    }

    abstract Iterator<NamedToken> tokens(TokenRead var1);

    abstract R token(NamedToken var1);

    abstract boolean inUse(KernelTransaction var1, SchemaReadCore var2, int var3);

    private static abstract class TokenIterator<T>
    extends PrefetchingIterator<T> {
        protected final TokenAccess<T> access;
        protected final Iterator<NamedToken> tokens;

        private TokenIterator(KernelTransaction transaction, TokenAccess<T> access) {
            this.access = access;
            this.tokens = access.tokens(transaction.tokenRead());
        }
    }
}

