/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipTypeIndexCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DefaultThreadSafeCursors
extends DefaultCursors
implements CursorFactory {
    private final StorageReader storageReader;
    private final Function<CursorContext, StoreCursors> storeCursorsFactory;

    public DefaultThreadSafeCursors(StorageReader storageReader, Config config, Function<CursorContext, StoreCursors> storeCursorsFactory) {
        super(new ConcurrentLinkedQueue<DefaultCursors.CloseableStacktrace>(), config);
        this.storageReader = storageReader;
        this.storeCursorsFactory = storeCursorsFactory;
    }

    public DefaultNodeCursor allocateNodeCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultNodeCursor(defaultNodeCursor -> {
            defaultNodeCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateNodeCursor(cursorContext, storeCursors), this.storageReader.allocateNodeCursor(cursorContext, storeCursors), this.storageReader.allocateRelationshipTraversalCursor(cursorContext, storeCursors)));
    }

    public FullAccessNodeCursor allocateFullAccessNodeCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessNodeCursor(defaultNodeCursor -> {
            defaultNodeCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateNodeCursor(cursorContext, storeCursors)));
    }

    public DefaultRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultRelationshipScanCursor(defaultRelationshipScanCursor -> {
            defaultRelationshipScanCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors), this.allocateNodeCursor(cursorContext)));
    }

    public FullAccessRelationshipScanCursor allocateFullAccessRelationshipScanCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessRelationshipScanCursor(defaultRelationshipScanCursor -> {
            defaultRelationshipScanCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors)));
    }

    public DefaultRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultRelationshipTraversalCursor(defaultRelationshipTraversalCursor -> {
            defaultRelationshipTraversalCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, storeCursors), this.allocateNodeCursor(cursorContext)));
    }

    public DefaultRelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(CursorContext cursorContext) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessRelationshipTraversalCursor(defaultRelationshipTraversalCursor -> {
            defaultRelationshipTraversalCursor.release();
            storeCursors.close();
        }, this.storageReader.allocateRelationshipTraversalCursor(cursorContext, storeCursors)));
    }

    public PropertyCursor allocatePropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new DefaultPropertyCursor(defaultPropertyCursor -> {
            defaultPropertyCursor.release();
            storeCursors.close();
        }, this.storageReader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker), this.allocateFullAccessNodeCursor(cursorContext), this.allocateFullAccessRelationshipScanCursor(cursorContext)));
    }

    public PropertyCursor allocateFullAccessPropertyCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        StoreCursors storeCursors = this.storeCursorsFactory.apply(cursorContext);
        return this.trace(new FullAccessPropertyCursor(defaultPropertyCursor -> {
            defaultPropertyCursor.release();
            storeCursors.close();
        }, this.storageReader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker)));
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.trace(new DefaultNodeValueIndexCursor(DefaultNodeValueIndexCursor::release, this.allocateNodeCursor(cursorContext), memoryTracker));
    }

    public NodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.trace(new FullAccessNodeValueIndexCursor(DefaultNodeValueIndexCursor::release, memoryTracker));
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(CursorContext cursorContext) {
        return this.trace(new DefaultNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release, this.allocateNodeCursor(cursorContext)));
    }

    public NodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(CursorContext cursorContext) {
        return this.trace(new FullAccessNodeLabelIndexCursor(DefaultNodeLabelIndexCursor::release));
    }

    public RelationshipValueIndexCursor allocateRelationshipValueIndexCursor(CursorContext cursorContext, MemoryTracker memoryTracker) {
        return this.trace(new DefaultRelationshipValueIndexCursor(DefaultRelationshipValueIndexCursor::release, this.allocateRelationshipScanCursor(cursorContext), memoryTracker));
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor(CursorContext cursorContext) {
        return this.trace(new DefaultRelationshipTypeIndexCursor(DefaultRelationshipTypeIndexCursor::release, this.allocateRelationshipScanCursor(cursorContext)));
    }

    public RelationshipTypeIndexCursor allocateFullAccessRelationshipTypeIndexCursor() {
        return this.trace(new FullAccessRelationshipTypeIndexCursor(DefaultRelationshipTypeIndexCursor::release));
    }

    public void close() {
        this.assertClosed();
        this.storageReader.close();
    }
}

