/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.TokenSet;

public class Labels
implements TokenSet {
    private final long[] labelIds;

    private Labels(long[] labelIds) {
        this.labelIds = labelIds;
    }

    public static Labels from(long ... labels) {
        return new Labels(labels);
    }

    static Labels from(LongSet set) {
        return new Labels(set.toArray());
    }

    public int numberOfTokens() {
        return this.labelIds.length;
    }

    public int token(int offset) {
        return (int)this.labelIds[offset];
    }

    public boolean contains(int token) {
        for (long label : this.labelIds) {
            assert ((long)((int)label) == label) : "value too big to be represented as and int";
            if (label != (long)token) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Labels" + Arrays.toString(this.labelIds);
    }

    public long[] all() {
        return this.labelIds;
    }
}

