/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.security.URLAccessValidationError;

public class WebURLAccessRule
implements URLAccessRule {
    public static final String LOAD_CSV_USER_AGENT_PREFIX = "NeoLoadCSV_";
    private static final int REDIRECT_LIMIT = 10;

    public static String userAgent() {
        Runtime.Version version = Runtime.version();
        String agent = System.getProperty("http.agent");
        if (agent == null) {
            return "Java/" + version;
        }
        return agent + " Java/" + version;
    }

    @Deprecated(forRemoval=true)
    public static void checkNotBlocked(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        new WebURLAccessRule().checkNotBlockedAndPinToIP(url, blockedIpRanges);
    }

    public URL checkNotBlockedAndPinToIP(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(url.getHost());
        URL result = url;
        for (IPAddressString blockedIpRange : blockedIpRanges) {
            if (!blockedIpRange.contains(new IPAddressString(inetAddress.getHostAddress()))) continue;
            throw new URLAccessValidationError("access to " + inetAddress + " is blocked via the configuration property " + GraphDatabaseInternalSettings.cypher_ip_blocklist.name());
        }
        if (url.getProtocol().equals("http") || url.getProtocol().equals("ftp")) {
            result = this.substituteHostByIP(url, inetAddress.getHostAddress());
        }
        return result;
    }

    protected URL substituteHostByIP(URL u, String ip) throws MalformedURLException {
        String s = u.getUserInfo();
        Object object = s != null && !s.isEmpty() ? s + "@" : "";
        s = u.getHost();
        String string = s != null && !s.isEmpty() ? ip : "";
        int port = u.getPort();
        s = u.getPath();
        String string2 = s != null ? s : "";
        s = u.getQuery();
        Object object2 = s != null ? "?" + s : "";
        s = u.getRef();
        String newURLString = u.getProtocol() + "://" + (String)object + string + (String)(port != u.getDefaultPort() && port > 0 ? ":" + Integer.toString(port) : "") + string2 + (String)object2 + (String)(s != null ? "#" + s : "");
        return new URL(newURLString);
    }

    public URLConnection checkUrlIncludingHops(URL url, List<IPAddressString> blockedIpRanges) throws Exception {
        URLConnection urlCon;
        boolean keepFollowingRedirects;
        URL result = url;
        int redirectLimit = 10;
        do {
            if ((urlCon = (result = this.checkNotBlockedAndPinToIP(result, blockedIpRanges)).openConnection()) instanceof HttpURLConnection) {
                URL newUrl;
                HttpURLConnection httpCon = (HttpURLConnection)urlCon;
                httpCon.setRequestProperty("User-Agent", String.format("%s%s", LOAD_CSV_USER_AGENT_PREFIX, WebURLAccessRule.userAgent()));
                httpCon.setInstanceFollowRedirects(false);
                httpCon.connect();
                httpCon.getInputStream();
                keepFollowingRedirects = WebURLAccessRule.isRedirect(httpCon.getResponseCode());
                if (!keepFollowingRedirects) continue;
                if (redirectLimit-- == 0) {
                    httpCon.disconnect();
                    throw new IOException("Redirect limit exceeded");
                }
                String location = httpCon.getHeaderField("Location");
                if (location == null) {
                    httpCon.disconnect();
                    throw new IOException("URL responded with a redirect but the location header was null");
                }
                try {
                    newUrl = new URL(location);
                    if (!newUrl.getProtocol().equalsIgnoreCase(result.getProtocol())) {
                        return httpCon;
                    }
                }
                catch (MalformedURLException e) {
                    newUrl = new URL(httpCon.getURL(), location);
                }
                result = newUrl;
                continue;
            }
            keepFollowingRedirects = false;
        } while (keepFollowingRedirects);
        return urlCon;
    }

    private static boolean isRedirect(int responseCode) {
        return responseCode >= 300 && responseCode <= 307 && responseCode != 306 && responseCode != 304;
    }

    public URL validate(Configuration config, URL url) throws URLAccessValidationError {
        List blockedIpRanges = (List)config.get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        String host = url.getHost();
        if (!blockedIpRanges.isEmpty() && host != null && !host.isEmpty()) {
            try {
                URLConnection con = this.checkUrlIncludingHops(url, blockedIpRanges);
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
            }
            catch (Exception e) {
                throw new URLAccessValidationError("Unable to verify access to " + host + ". Cause: " + e.getMessage());
            }
        }
        return url;
    }
}

