/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.util.Objects;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;

public class RecoveryStartupChecker {
    public static final RecoveryStartupChecker EMPTY_CHECKER = new NeverCanceledChecker();
    private final DatabaseStartupController databaseStartupController;
    private final NamedDatabaseId namedDatabaseId;

    public RecoveryStartupChecker(DatabaseStartupController databaseStartupController, NamedDatabaseId namedDatabaseId) {
        this.databaseStartupController = Objects.requireNonNull(databaseStartupController);
        this.namedDatabaseId = namedDatabaseId;
    }

    void checkIfCanceled() throws DatabaseStartAbortedException {
        if (this.databaseStartupController.shouldAbort(this.namedDatabaseId)) {
            throw new DatabaseStartAbortedException(this.namedDatabaseId);
        }
    }

    private static class NeverCanceledChecker
    extends RecoveryStartupChecker {
        private NeverCanceledChecker() {
            super(DatabaseStartupController.NEVER_ABORT, null);
        }

        @Override
        void checkIfCanceled() {
        }
    }
}

