/*
 * Decompiled with CFR 0.152.
 */
package cqure.repeng;

import cqure.repeng.ReportObject;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class ReportTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final String ICON_PATH = "cqure/repeng/icons/";
    private ImageIcon m_oCriticalIcon = null;
    private ImageIcon m_oWarningIcon = null;
    private ImageIcon m_oInfoIcon = null;

    public ReportTreeCellRenderer() {
        this.setOpaque(false);
        this.setBackground(null);
        this.m_oCriticalIcon = ReportTreeCellRenderer.createImageIcon("cqure/repeng/icons/critical.gif");
        this.m_oWarningIcon = ReportTreeCellRenderer.createImageIcon("cqure/repeng/icons/warning.gif");
        this.m_oInfoIcon = ReportTreeCellRenderer.createImageIcon("cqure/repeng/icons/info.gif");
    }

    protected static ImageIcon createImageIcon(String path) {
        if (path != null) {
            return new ImageIcon(path);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setFont(tree.getFont());
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.setText(stringValue);
        if (sel) {
            this.setForeground(Color.blue);
        } else {
            this.setForeground(Color.black);
        }
        if (leaf) {
            this.setIcon(UIManager.getIcon("Tree.leafIcon"));
        } else if (expanded) {
            this.setIcon(UIManager.getIcon("Tree.openIcon"));
        } else {
            this.setIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        if (value instanceof ReportObject) {
            ReportObject oRo = (ReportObject)value;
            if (oRo.getSeverity() == 2002) {
                this.setIcon(this.m_oCriticalIcon);
            } else if (oRo.getSeverity() == 2001) {
                this.setIcon(this.m_oWarningIcon);
            } else {
                this.setIcon(this.m_oInfoIcon);
            }
        }
        return this;
    }
}

