/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestClientBrowserCache
extends AbstractAppPlugin {
    public static final Pattern patternNoCache = Pattern.compile("\\QNo-cache\\E|\\QNo-store\\E", 10);
    public static final Pattern patternHtmlNoCache = Pattern.compile("<META[^>]+(Pragma|\\QCache-Control\\E)[^>]+(\\QNo-cache\\E|\\QNo-store\\E)[^>]*>", 10);

    public int getId() {
        return 10002;
    }

    public String getName() {
        return "Secure page browser cache";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "Secure page can be cached in browser.  Cache control is not set in HTTP header nor HTML header.  Sensitive content can be recovered from browser storage.";
    }

    public int getCategory() {
        return 1;
    }

    public String getSolution() {
        String string = "The best way is to set HTTP header with: 'Pragma: No-cache' and 'Cache-control: No-cache'.\r\nAlternatively, this can be set in the HTML header by:\r\n<META HTTP-EQUIV='Pragma' CONTENT='no-cache'>\r\n<META HTTP-EQUIV='Cache-Control' CONTENT='no-cache'>\r\nbut some browsers may have problem using this method.";
        return string;
    }

    public String getReference() {
        String string = ". How to prevent caching in Internet Explorer - http://support.microsoft.com/default.aspx?kbid=234067\r\n. Pragma: No-cache Tag May Not Prevent Page from Being Cached - http://support.microsoft.com/default.aspx?kbid=222064";
        return string;
    }

    public void init() {
    }

    public void scan() {
        HttpMessage httpMessage = this.getBaseMsg();
        boolean bl = false;
        if (!httpMessage.getRequestHeader().getSecure()) {
            return;
        }
        if (httpMessage.getRequestHeader().isImage()) {
            return;
        }
        if (httpMessage.getResponseBody().length() == 0) {
            return;
        }
        if (!(this.matchHeaderPattern(httpMessage, "Cache-control", patternNoCache) || this.matchHeaderPattern(httpMessage, "Pragma", patternNoCache) || this.matchBodyPattern(httpMessage, patternHtmlNoCache, null))) {
            bl = true;
        }
        if (bl) {
            this.bingo(2, 1, null, null, "", httpMessage);
        }
    }
}

