/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogGetQuery
extends FilterAdaptor {
    private static final String delim = "\t";
    private static final String CRLF = "\r\n";
    private File outFile;
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();

    public int getId() {
        return 20;
    }

    public String getName() {
        return "Log unique GET queries into file (" + this.getLogFileName() + ")";
    }

    public void init() {
        this.outFile = new File(this.getLogFileName());
    }

    protected String getLogFileName() {
        return "filter/get.xls";
    }

    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        if (httpRequestHeader != null && httpRequestHeader.isText() && !httpRequestHeader.isImage() && httpRequestHeader.getMethod().equalsIgnoreCase("GET")) {
            try {
                URI uRI = httpRequestHeader.getURI();
                URI uRI2 = (URI)uRI.clone();
                String string = uRI2.getQuery();
                if (string != null) {
                    uRI2.setQuery(null);
                    String string2 = uRI2.toString();
                    Hashtable hashtable = this.parseParameter(string);
                    this.writeLogFile(string2, hashtable);
                } else {
                    String string3 = uRI.toString();
                    this.writeLogFile(string3, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }

    protected synchronized void writeLogFile(String string, Hashtable hashtable) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write(string + CRLF);
            }
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)hashtable.get(string2);
                    this.getWriter().write(delim + string2 + delim + string3 + CRLF);
                }
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Hashtable parseParameter(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            this.matcher2 = this.pSeparator.matcher(string);
            while (this.matcher2.find()) {
                hashtable.put(this.matcher2.group(1), this.matcher2.group(2));
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
        }
        return hashtable;
    }

    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

