require 'dokidoki.module' [[ load ]]

local stb_image = require 'stb_image'
local graphics = require 'dokidoki.graphics'

local data = 
"\137\80\78\71\13\10\26\10\0\0\0\13\73\72\68\82\0\0\0\64\0\0\0\53\8\4\0\0\0"..
"\91\143\37\39\0\0\0\1\115\82\71\66\0\174\206\28\233\0\0\2\64\73\68\65\84\88"..
"\195\237\89\219\114\197\32\8\4\166\255\255\203\246\193\82\228\42\38\233\101"..
"\230\156\204\164\158\24\53\136\203\178\90\128\239\107\12\254\59\127\233\122"..
"\127\113\189\244\187\114\81\246\98\12\109\144\24\198\111\184\29\34\0\0\226"..
"\185\9\99\4\6\32\206\123\157\213\90\199\207\186\70\15\122\209\39\182\131"..
"\184\120\29\112\12\235\129\108\73\108\59\253\188\53\144\59\72\105\103\24\27"..
"\208\247\128\123\239\61\160\103\158\97\160\11\86\111\232\67\87\61\160\117"..
"\124\115\1\94\232\194\191\250\240\92\2\100\250\152\37\162\188\144\146\111"..
"\91\31\151\241\199\164\222\253\142\194\198\134\156\13\67\75\58\182\77\12\82"..
"\29\85\41\19\10\106\125\25\133\97\212\78\127\152\121\19\81\147\246\87\59"..
"\235\129\40\198\35\143\100\207\39\30\0\0\248\136\137\194\167\150\156\112"..
"\188\99\231\76\215\52\197\179\95\49\176\162\225\71\80\254\166\154\227\52\44"..
"\217\47\122\246\217\81\178\100\93\111\1\107\32\27\197\114\7\233\62\61\107"..
"\152\250\126\222\176\144\7\114\116\102\193\118\15\108\228\7\202\212\29\155"..
"\181\82\105\78\191\126\34\113\59\218\105\188\171\136\234\202\84\66\204\169"..
"\85\175\109\173\233\120\77\35\10\139\12\153\244\244\166\128\255\65\67\94"..
"\207\103\178\188\119\235\126\126\95\160\17\65\12\155\72\245\240\142\232\4"..
"\44\146\247\230\47\9\110\201\145\171\9\116\55\159\121\52\215\232\182\19\34"..
"\223\97\62\203\76\118\251\1\214\147\179\159\167\159\122\26\228\29\92\119"..
"\121\58\126\41\27\216\46\128\55\43\167\224\93\207\116\95\240\228\220\214\60"..
"\177\2\188\151\71\94\82\15\85\217\189\106\19\169\101\189\73\217\68\193\249"..
"\217\78\134\20\169\61\89\89\90\79\132\226\244\235\79\195\44\105\215\135\53"..
"\185\38\84\146\76\230\37\212\188\18\139\228\123\222\196\234\246\123\79\105"..
"\197\197\111\233\10\203\119\219\91\62\104\106\194\120\9\114\229\116\14\244"..
"\199\88\167\123\44\245\171\123\191\247\158\48\219\184\59\50\131\1\163\23\5"..
"\87\93\170\65\38\49\161\23\137\44\49\216\242\252\174\81\192\92\18\106\66"..
"\182\155\137\166\163\9\173\142\16\237\151\125\92\143\70\213\192\245\33\171"..
"\150\100\94\210\85\217\194\104\194\108\171\21\173\161\12\110\135\203\254"..
"\227\114\0\177\187\17\92\29\95\101\81\240\160\1\215\40\232\19\158\224\92\31"..
"\251\141\41\17\0\0\0\0\73\69\78\68\174\66\96\130"

local chars_per_row = 16

local char_width = 4
local char_height = 9

local char_size = {4, 9}
local char_origin = {0, char_height}

local start_code = string.byte(' ')
local end_code = string.byte('~')

-- looks like it wasn't such a good idea to pack the characters so tightly...
local epsilon = 0.01

function load()
  local tex, width, height = graphics.texture_from_string(
    assert(stb_image.load_from_string(data)))

  local fontmap = {}

  for code = start_code, end_code do
    local i = code - start_code
    local x = (i % chars_per_row) * char_width + epsilon
    local y = math.floor(i / chars_per_row) * char_height + epsilon
    local rect = {
      x/width,
      y/height,
      (char_width-epsilon*2)/width,
      (char_height-epsilon*2)/height
    }

    fontmap[string.char(code)] = graphics.make_sprite(
      tex, char_size, char_origin, rect)
  end

  return fontmap
end

return get_module_exports()
