% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R
\name{add_metadata<-}
\alias{add_metadata<-}
\alias{rename_metadata<-}
\alias{replace_metadata<-}
\title{Safe manipulation of object metadata}
\usage{
add_metadata(object, ...) <- value

rename_metadata(object, ...) <- value

replace_metadata(object, ...) <- value
}
\arguments{
\item{object}{(\strong{required}) object to manipulate}

\item{...}{further arguments passed to the specific class method}

\item{value}{the value to be assigned}
}
\description{
Generic functions for manipulation of metadata in \linkS4class{Risoe.BINfileData},
\linkS4class{RLum.Analysis} and \linkS4class{RLum.Data} objects.
}
\examples{

## load example data
data(ExampleData.BINfileData, envir = environment())

## show data
CWOSL.SAR.Data

## add a new field
add_metadata(CWOSL.SAR.Data,
             info_element = "INSTITUTE") <- "Heidelberg University"

## rename a field
rename_metadata(CWOSL.SAR.Data,
                info_element = "INSTITUTE") <- "INSTITUTION"

## replace all LTYPE to RSL
## but only for the first position
replace_metadata(
 object = CWOSL.SAR.Data,
 info_element = "LTYPE",
 subset = (POSITION == 1)) <- "RSL"

## replacing a field with NULL allows to remove that field
replace_metadata(CWOSL.SAR.Data,
                 info_element = "PREVIOUS") <- NULL

## show the modified data
CWOSL.SAR.Data

}
\seealso{
\linkS4class{RLum.Data}, \linkS4class{RLum.Analysis}, \linkS4class{Risoe.BINfileData}
}
\author{
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Colombo, M., 2025. add_metadata<-(): Safe manipulation of object metadata. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.1. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
