% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_quantile.R
\name{cut_quantile}
\alias{cut_quantile}
\title{Convert numeric to factor with intervals of equal number of items by using quantiles}
\usage{
cut_quantile(x, breaks, labels = NULL, ...)
}
\arguments{
\item{x}{An R object, usually a numeric vector.}

\item{breaks}{A single integer with the number of breaks to use.}

\item{labels}{Labels for the resulting category or \code{NULL} (by default) to
construct them automatically like "(a,b]". If \code{labels = FALSE}, simple
integer codes are returned instead of factor.}

\item{...}{Further arguments passed to \code{\link[=cut]{cut()}}.}
}
\value{
A \code{\link[=factor]{factor()}} is returned, unless \code{labels = FALSE} (in this case, a
integer vector is obtained).
}
\description{
\code{cut_quantile()} is like \code{\link[=cut]{cut()}}, but it calculates intervals
from quantiles such that each interval has approximately the same number of
items from the original vector. \code{x} must have both \code{\link[=quantile]{quantile()}} and \code{\link[=cut]{cut()}}
methods implemented.
}
\examples{
# Transform a numeric vector into a factor with 5 levels of same item numbers
vec <- rnorm(20)
fact <- cut_quantile(vec, breaks = 5)
fact
table(fact)
}
