# Contributing

## <a id="openParticipation">Public Participation Invited</a>

This [OASIS TC Open Repository](https://www.oasis-open.org/resources/open-repositories) ( **[github.com/oasis-open/cti-pattern-validator](https://github.com/oasis-open/cti-pattern-validator)** ) is a community public repository that supports participation by anyone, whether affiliated with OASIS or not. Substantive contributions (repository "code") and related feedback is invited from all parties, following the common conventions for participation in GitHub public repository projects. Participation is expected to be consistent with the [OASIS TC Open Repository Guidelines and Procedures](https://www.oasis-open.org/policies-guidelines/open-repositories), the [LICENSE](https://www.oasis-open.org/sites/www.oasis-open.org/files/BSD-3-Clause.txt) designated for this particular repository (BSD-3-Clause License), and the requirement for an [Individual Contributor License Agreement](https://www.oasis-open.org/resources/open-repositories/cla/individual-cla). Please see the repository [README](https://github.com/oasis-open/cti-pattern-validator/blob/master/README.md) document for other details.

## <a id="distinctRules">Governance Distinct from OASIS TC Process</a>

Content accepted as "contributions" to this TC Open Repository, as [defined](#openRepoContribution) below, are distinct from any [Contributions](https://www.oasis-open.org/policies-guidelines/ipr#contributions) made to the associated [OASIS Cyber Threat Intelligence (CTI) TC](https://www.oasis-open.org/committees/cti/) itself. Participation in the associated Technical Committee is governed by the [OASIS Bylaws](https://www.oasis-open.org/policies-guidelines/bylaws), [OASIS TC Process](https://www.oasis-open.org/policies-guidelines/tc-process), [IPR Policy](https://www.oasis-open.org/policies-guidelines/ipr), and related [policies](https://www.oasis-open.org/policies-guidelines/). This TC Open Repository is not subject to the OASIS TC-related policies. TC Open Repository governance is defined by separate [participation and contribution guidelines](https://www.oasis-open.org/policies-guidelines/open-repositories) as referenced in the [OASIS TC Open Repositories Overview](https://www.oasis-open.org/resources/open-repositories/).

## <a id="distinctLicenses">Licensing Distinct from OASIS IPR Policy</a>

Because different licenses apply to the OASIS TC's specification work, and this TC Open Repository, there is no guarantee that the licensure of specific repository material will be compatible with licensing requirements of an implementation of a TC's specification. Please refer to the [LICENSE file](https://github.com/oasis-open/cti-pattern-validator/blob/master/LICENSE) for the terms of this material, and to the OASIS IPR Policy for [the terms applicable to the TC's specifications](https://www.oasis-open.org/policies-guidelines/ipr#Non-Assertion-Mode), including any applicable [declarations](https://www.oasis-open.org/committees/cti/ipr.php).

## <a id="contributionDefined">Contributions Subject to Individual CLA</a>

Formally, <a id="openRepoContribution">"contribution"</a> to this TC Open Repository refers to content merged into the "Code" repository (repository changes represented by code [commits](https://github.com/oasis-open/cti-pattern-validator/commits/master)), following the GitHub definition of _[contributor](https://help.github.com/articles/github-glossary/#contributor)_: "someone who has contributed to a project by having a pull request merged but does not have collaborator [*i.e.*, direct write] access." Anyone who signs the TC Open Repository [Individual Contributor License Agreement (CLA)](https://www.oasis-open.org/resources/open-repositories/cla/individual-cla), signifying agreement with the licensing requirement, may contribute substantive content — subject to evaluation of a GitHub pull request. The main web page for this repository, as with any GitHub public repository, displays a link to a document listing contributions to the repository's default branch (filtered by Commits, Additions, and Deletions).

This TC Open Repository, as with GitHub public repositories generally, also accepts public feedback from any GitHub user. Public feedback includes opening issues, authoring and editing comments, participating in conversations, making wiki edits, creating repository stars, and making suggestions via pull requests. Such feedback does not constitute an OASIS TC Open Repository [contribution](#openRepoContribution). Some details are presented under "Read permissions" in the table of [permission levels](https://help.github.com/articles/repository-permission-levels-for-an-organization/) for a GitHub organization. Technical content intended as a substantive contribution (repository "Code") to an TC Open Repository is subject to evaluation, and requires a signed Individual CLA.

## <a id="fork-and-pull-model">Fork-and-Pull Collaboration Model</a>

OASIS TC Open Repositories use the familiar [fork-and-pull](https://help.github.com/articles/using-pull-requests/#fork--pull) collaboration model supported by GitHub and other distributed version-control systems. Any GitHub user wishing to contribute should [fork](https://help.github.com/articles/github-glossary/#fork) the repository, make additions or other modifications, and then submit a pull request. GitHub pull requests should be accompanied by supporting [comments](https://help.github.com/articles/commenting-on-the-diff-of-a-pull-request/) and/or [issues](https://help.github.com/articles/about-issues/). Community conversations about pull requests, supported by GitHub [notifications](https://help.github.com/articles/about-notifications/), will provide the basis for a consensus determination to merge, modify, close, or take other action, as communicated by the repository [Maintainers](https://www.oasis-open.org/resources/open-repositories/maintainers-guide).

## <a id="feedback">Feedback</a>

Questions or comments about this TC Open Repository's activities should be composed as GitHub issues or comments. If use of an issue/comment is not possible or appropriate, questions may be directed by email to the [repository Maintainer(s)](https://github.com/oasis-open/cti-pattern-validator/blob/master/README.md#maintainers). Please send general questions about TC Open Repository participation to OASIS Staff at [repository-admin@oasis-open.org](mailto:repository-admin@oasis-open.org) and any specific CLA-related questions to [repository-cla@oasis-open.org](mailto:repository-cla@oasis-open.org).
