/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.invoker;

import java.lang.reflect.Method;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.NestableException;
import org.openamf.AMFBody;
import org.openamf.AMFError;
import org.openamf.ServiceRequest;

public class ServiceInvocationException
extends NestableException {
    protected AMFBody requestBody;
    protected ServiceRequest request;

    public ServiceInvocationException(AMFBody requestBody, Throwable cause) {
        super(cause);
        this.requestBody = requestBody;
    }

    public ServiceInvocationException(ServiceRequest request, Throwable cause) {
        super(cause);
        this.request = request;
    }

    public AMFBody getAMFBody() {
        return this.requestBody;
    }

    public ServiceRequest getServiceRequest() {
        return this.request;
    }

    public AMFError getAMFError() {
        AMFError amfError = new AMFError();
        Throwable rootCause = this.getCause();
        amfError.setCode(this.getErrorValue(rootCause, "getCode", "SERVER.PROCESSING"));
        amfError.setLevel(this.getErrorValue(rootCause, "getError", "error"));
        amfError.setType(rootCause.getClass().getName());
        amfError.setDetails(ExceptionUtils.getStackTrace((Throwable)rootCause));
        amfError.setDescription(this.getErrorValue(rootCause, "getDescription", rootCause.getMessage()));
        return amfError;
    }

    private String getErrorValue(Throwable cause, String methodName, String defaultValue) {
        String value = null;
        try {
            Method method = cause.getClass().getMethod(methodName, new Class[0]);
            value = (String)method.invoke((Object)cause, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

