/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import org.apache.bsf.BSFException;
import org.apache.bsf.engines.javascript.CompilationUnit;
import org.apache.bsf.engines.javascript.DocumentCell;
import org.apache.bsf.engines.javascript.FnOrScript;

public class BreakPoint {
    protected int m_brkptId;
    protected int m_lineno;
    protected int m_offset;
    protected boolean m_lineDefined;
    protected DocumentCell m_cell;
    protected FnOrScript m_fnOrScript;
    protected CompilationUnit m_unit;

    public BreakPoint(BreakPoint breakPoint) {
        this.m_fnOrScript = breakPoint.m_fnOrScript;
        this.m_cell = breakPoint.m_cell;
        this.m_brkptId = breakPoint.m_brkptId;
        this.m_lineno = breakPoint.m_lineno;
        this.m_offset = breakPoint.m_offset;
        this.m_lineDefined = breakPoint.m_lineDefined;
        this.m_unit = breakPoint.m_unit;
    }

    public BreakPoint(DocumentCell documentCell, int n) {
        this.m_fnOrScript = null;
        this.m_cell = documentCell;
        this.m_brkptId = n;
        this.m_lineno = -1;
        this.m_lineDefined = true;
        this.m_unit = null;
    }

    public void setUnit(CompilationUnit compilationUnit) {
        this.m_unit = compilationUnit;
    }

    public void propagate() {
        if (this.m_unit != null) {
            this.m_unit.propagate(this.m_lineno);
        }
    }

    public void unpropagate() {
        if (this.m_unit != null) {
            this.m_unit.unpropagate(this.m_lineno);
        }
    }

    public void attachToFnOrScript(FnOrScript fnOrScript) {
        this.m_fnOrScript = fnOrScript;
    }

    public int getId() {
        return this.m_brkptId;
    }

    public int getLineNo() throws BSFException {
        if (!this.m_lineDefined) {
            throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Breakpoint is offset defined, can't provide its line number.");
        }
        return this.m_lineno;
    }

    public int getOffset() throws BSFException {
        if (this.m_lineDefined) {
            throw new BSFException(BSFException.REASON_INVALID_ARGUMENT, "Breakpoint is line defined, can't provide its offset.");
        }
        return this.m_offset;
    }

    public void setLineNo(int n) {
        this.m_lineno = n;
    }

    public void setOffset(int n) {
        this.m_offset = n;
    }
}

