/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager;

import com.paterva.maltego.entity.api.EntitySpecSerializer;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.util.XmlSerializationException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class EntitySpecTransferable
implements Transferable {
    public static final DataFlavor DataFlavour = new DataFlavor(MaltegoEntitySpec.class, "Entity Specification");
    private static final DataFlavor[] SupportedFlavors = new DataFlavor[]{DataFlavour, DataFlavor.stringFlavor};
    private MaltegoEntitySpec _data;

    public EntitySpecTransferable(MaltegoEntitySpec data) {
        this._data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return SupportedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavour) || flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavour)) {
            return this._data;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return EntitySpecTransferable.toString(this._data);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(MaltegoEntitySpec spec) {
        EntitySpecSerializer serializer = EntitySpecSerializer.getDefault();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            serializer.write(spec, (OutputStream)os);
            String string = os.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            String string = "";
            return string;
        }
        catch (XmlSerializationException ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

