/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.imex.ServiceWrapper;
import com.paterva.maltego.pws.oauth.OAuthWebService;
import com.paterva.maltego.pws.serialization.OAuthServiceSerializer;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class ServiceEntry
extends Entry<ServiceWrapper> {
    private static final Logger LOGGER = Logger.getLogger(ServiceEntry.class.getName());
    protected static final String DEFAULT_FOLDER = "Services";
    protected static final String TYPE = "service";

    public ServiceEntry(ServiceWrapper wrapper) {
        super((Object)wrapper, "Services/" + wrapper.getServiceType(), wrapper.getFileName() + "." + TYPE, wrapper.getService().getName());
    }

    public ServiceEntry(String path) {
        super(path);
    }

    protected ServiceWrapper read(InputStream is) throws IOException {
        String subfolder = this.getFolder().substring(DEFAULT_FOLDER.length() + 1);
        ServiceWrapper wrapper = null;
        try {
            if ("OAuth".equals(subfolder)) {
                OAuthWebService service = new OAuthServiceSerializer().read(is);
                wrapper = new ServiceWrapper(subfolder, this.getTypeName(), service);
            } else {
                this.showTypeError(subfolder);
            }
        }
        catch (XmlSerializationException | GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return wrapper;
    }

    protected void write(ServiceWrapper wrapper, OutputStream os) throws IOException {
        String type = wrapper.getServiceType();
        if ("OAuth".equals(type)) {
            OAuthServiceSerializer serializer = new OAuthServiceSerializer();
            PublicWebService service = wrapper.getService();
            if (service instanceof OAuthWebService) {
                try {
                    serializer.write((OAuthWebService)service, os);
                }
                catch (XmlSerializationException | GeneralSecurityException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                LOGGER.log(Level.WARNING, "{0} service must be of type {1}", new String[]{type, OAuthWebService.class.getSimpleName()});
            }
        } else {
            this.showTypeError(type);
        }
    }

    private void showTypeError(String subfolder) {
        LOGGER.log(Level.WARNING, "{0} services not supported yet", subfolder);
    }
}

