/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.protocol.v2api.LocalTransformAdapterV2;
import com.paterva.maltego.transform.protocol.v2api.RemoteTransformAdapterV2;
import com.paterva.maltego.transform.protocol.v3.api.RemoteTransformAdapterV3;
import com.paterva.maltego.transform.runner.api.TransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformAdapterFactory;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import java.util.Objects;
import java.util.Optional;

public class DefaultTransformAdapterFactory
extends TransformAdapterFactory {
    public TransformAdapter get(TransformRunContext ctx) {
        boolean isLocalTransform = ctx.getServer().map(server -> server.getDefaultRepository()).filter(repo -> Objects.equals(repo, "Local")).isPresent();
        if (isLocalTransform) {
            return new LocalTransformAdapterV2();
        }
        ProtocolVersion protocolVersion = ctx.getTransform().getProtocolVersion();
        Optional serverInfo = ctx.getServer();
        if (serverInfo.isPresent()) {
            protocolVersion = ((TransformServerInfo)serverInfo.get()).getV3Url() == null ? ProtocolVersion.V2_0 : ((TransformServerInfo)serverInfo.get()).getProtocolVersion();
        }
        if (protocolVersion.equals((Object)ProtocolVersion.V2_0)) {
            return new RemoteTransformAdapterV2();
        }
        if (protocolVersion.compareTo(ProtocolVersion.V3_0) >= 0) {
            return new RemoteTransformAdapterV3();
        }
        throw new IllegalArgumentException(String.format("Failed to create a transform adapter, unsupported protocol version: %s", protocolVersion));
    }
}

