/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.slider;

import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.transform.runner.slider.TransformSliderTickProvider;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIDefaults;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

class TransformToolbar
extends JPanel {
    public static final String PROP_VALUE = "value";
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final Color LABEL_FOREGROUND = LAF.getColor("Slider.darculaMod.labelForegroundColor");
    private static final Color LABEL_DISABLED_FOREGROUND = LAF.getColor("Slider.darculaMod.labelDisabledForegroundColor");
    private TransformSliderTickProvider _tickProvider;
    private int _value;
    private JSlider _slider;
    private JLabel _sliderLabel;

    public TransformToolbar() {
        this.initComponents();
        this._tickProvider = new TransformSliderTickProvider();
        LicenseManager.A().A(ignored -> this.update());
        this.update();
        this._slider.addChangeListener(ignored -> {
            if (!this._slider.getValueIsAdjusting()) {
                int tickIndex = this._slider.getValue() - 1;
                int lookUpValue = this._tickProvider.getValue(tickIndex);
                if (this._slider.getValue() == this._slider.getMaximum()) {
                    String msg = "You've selected to return up to " + lookUpValue + " entities. Are you sure you want to continue?";
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Are you sure...", 2);
                    if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                        this.setValue(lookUpValue);
                    } else {
                        this._slider.setValue(--tickIndex + 1);
                        this.setValue(this._tickProvider.getValue(tickIndex));
                    }
                } else {
                    this.setValue(lookUpValue);
                }
            }
        });
        this._slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TransformToolbar.this._slider.isEnabled()) {
                    LicenseManager licMan = LicenseManager.A();
                    com.paterva.maltego.licensing.mode.A licenseMode = licMan.A(false);
                    boolean licensed = licenseMode.B() || licenseMode.W();
                    String sentenceText = licensed ? "upgrading" : "buying";
                    String msg = "The transform result slider can not be changed on this Maltego Plan.\nPlease consider " + sentenceText + " Maltego to unlock this and other features.";
                    NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)msg, "Upgrade Maltego");
                    String actionOption = licensed ? "Upgrade" : "Buy";
                    String cancelOption = "Cancel";
                    Object[] options = new String[]{actionOption, cancelOption};
                    conf.setOptions(options);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)conf);
                    if (actionOption.equals(result)) {
                        String licenseKey;
                        String string = licenseKey = licenseMode.B() ? licMan.C() : null;
                        if (licensed) {
                            BrowseToUrl.upgradePlan((String)licenseKey);
                        } else {
                            BrowseToUrl.buyPlan((String)licenseKey);
                        }
                        ProductSelectionAction.perform();
                    }
                }
            }
        });
    }

    private void update() {
        Color color;
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>(this._tickProvider.getTickCount());
        Color fgColor = this._sliderLabel.getForeground();
        this._slider.setMaximum(this._tickProvider.getTickCount());
        for (int i = 0; i < this._tickProvider.getTickCount(); ++i) {
            color = this._tickProvider.getColor(i);
            labelTable.put(i + 1, this.createLabel(this._tickProvider.getLabel(i), color != null ? color : fgColor));
        }
        this._slider.setLabelTable(labelTable);
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        if (!A.G((com.paterva.maltego.licensing.mode.A)licenseMode)) {
            this._sliderLabel.setForeground(LABEL_DISABLED_FOREGROUND);
            this._slider.setEnabled(false);
        } else {
            this._sliderLabel.setForeground(LABEL_FOREGROUND);
            this._slider.setEnabled(true);
        }
        color = this._sliderLabel.getForeground();
        Enumeration elements = labelTable.elements();
        while (elements.hasMoreElements()) {
            Object nextElement = elements.nextElement();
            if (!(nextElement instanceof JComponent)) continue;
            JComponent component = (JComponent)nextElement;
            component.setForeground(color);
        }
        if (!A.G((com.paterva.maltego.licensing.mode.A)licenseMode)) {
            this._slider.setValue(1);
            if (this._tickProvider != null) {
                this.setValue(this._tickProvider.getValue(0));
            }
        }
        boolean defaultFound = false;
        for (int i = 0; i < this._tickProvider.getTickCount() && !defaultFound; ++i) {
            if (this._tickProvider.getValue(i) != this._tickProvider.getDefault()) continue;
            this._slider.setValue(i + 1);
            this.setValue(this._tickProvider.getValue(i));
            defaultFound = true;
        }
        if (!defaultFound) {
            this._slider.setValue(1);
            this.setValue(this._tickProvider.getValue(0));
        }
    }

    public final void setValue(int value) {
        if (this._value != value) {
            int old = this._value;
            this._value = value;
            this._tickProvider.setDefault(this._value);
            this.firePropertyChange(PROP_VALUE, old, value);
        }
    }

    public int getValue() {
        return this._value;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension labelPrefSize = this._sliderLabel.getPreferredSize();
        int width = labelPrefSize.width + insets.left + insets.right;
        int height = labelPrefSize.height + this._slider.getPreferredSize().height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    private JLabel createLabel(String text, Color color) {
        JLabel label = new JLabel(text);
        label.setFont(this._sliderLabel.getFont());
        label.setForeground(color);
        return label;
    }

    private void initComponents() {
        this._slider = new JSlider();
        this._sliderLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 1, 1));
        this.setToolTipText("");
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setName("");
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this._slider.setMajorTickSpacing(1);
        this._slider.setMaximum(4);
        this._slider.setMinimum(1);
        this._slider.setMinorTickSpacing(1);
        this._slider.setPaintLabels(true);
        this._slider.setPaintTicks(true);
        this._slider.setSnapToTicks(true);
        this._slider.setToolTipText("The number of results returned by the transform.");
        this._slider.setValue(1);
        this._slider.setMinimumSize(new Dimension(36, 52));
        this._slider.setOpaque(true);
        this._slider.setRequestFocusEnabled(false);
        this._slider.setValueIsAdjusting(true);
        this.add((Component)this._slider, "Center");
        this._sliderLabel.setHorizontalAlignment(0);
        this._sliderLabel.setText("Number of Results");
        this._sliderLabel.setHorizontalTextPosition(2);
        this.add((Component)this._sliderLabel, "First");
    }
}

