/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.types.Converter;
import com.pinkmatter.types.Coordinate;
import com.pinkmatter.types.Geography;
import com.pinkmatter.types.SpatialException;
import com.pinkmatter.types.Tetragon;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;
import org.apache.lucene.spatial.serialized.SerializedSortedSetDVStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeographyConverter
extends AbstractTypeConverter<Geography> {
    protected static final String DETAIL_COLUMN = "*detail";
    private static final Logger LOG = LoggerFactory.getLogger(GeographyConverter.class);
    private static final float GRID_INDEX_ERROR = 0.2f;
    private static final float GRID_SEARCH_ERROR = 0.025f;
    private static final int GRID_MAX_LEVELS = 11;
    private final SpatialPrefixTree _grid;
    private final Map<String, SpatialStrategy> _strategies = new HashMap<String, SpatialStrategy>();

    protected GeographyConverter(String typeName, Class<? extends Geography> clazz) {
        super(typeName, clazz);
        this._grid = new GeohashPrefixTree((SpatialContext)Converter.getSpatialContext(), 11);
    }

    public GeographyConverter() {
        this("geo", (Class<? extends Geography>)Geography.class);
    }

    @Override
    public void write(Object value, String field, Document to) throws PandoraException {
        try {
            if (value != null) {
                LOG.debug("Writing field: {}, value: {}", (Object)field, value);
                if (!value.getClass().isArray()) {
                    this.writeImpl((Geography)value, field, to);
                } else {
                    this.writeArrayImpl((Geography[])value, field, to);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
            throw new PandoraException(String.format("Error writing field: %s with value: %s using converter: %s.", field, value, this.getType()), (Throwable)ex);
        }
    }

    @Override
    protected void writeImpl(Geography value, String field, Document to) {
        this.writeMultiImpl(field, to, value);
    }

    protected void writeArrayImpl(Geography[] values, String field, Document to) {
        this.writeMultiImpl(field, to, values);
    }

    private void writeMultiImpl(String field, Document to, Geography ... values) {
        String fieldName = this.getIndexField(field);
        Shape indexArea = Converter.toShape((Geography[])values);
        for (Field field2 : this.getStrategy(fieldName).createIndexableFields(indexArea)) {
            to.add((IndexableField)field2);
        }
        for (Field field3 : values) {
            String storeValue = Converter.write((Geography)field3);
            LOG.debug("Writing geography: {} to index", (Object)storeValue);
            StoredField storeField = new StoredField(fieldName, storeValue);
            to.add((IndexableField)storeField);
        }
    }

    private void print(Field indexField) {
        try {
            TokenStream stream = indexField.tokenStreamValue();
            GeographyConverter.displayTokens(stream);
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(GeographyConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void displayTokens(TokenStream stream) throws IOException {
        stream.reset();
        while (stream.incrementToken()) {
            System.out.println(stream.reflectAsString(false));
        }
        stream.end();
    }

    @Override
    protected Geography readImpl(IndexableField field) throws PandoraException {
        String storeValue = field.stringValue();
        LOG.debug("Reading geography: {} from index", (Object)storeValue);
        try {
            Geography result = Converter.read((String)storeValue);
            if (!this.getClassType().isAssignableFrom(result.getClass())) {
                throw new IllegalArgumentException("Converter cannot read value. Value must be of type " + this.getClassType());
            }
            return result;
        }
        catch (SpatialException ex) {
            throw new PandoraException("Error while reading geography from WKT: " + storeValue, (Throwable)ex);
        }
    }

    private SpatialStrategy getStrategy(String field) {
        SpatialStrategy strategy = this._strategies.get(field);
        if (strategy == null) {
            strategy = new CompositeSpatialStrategy(field, this.createIndexStrategy(field), this.createDetailStrategy(field));
            this._strategies.put(field, strategy);
        }
        return strategy;
    }

    private RecursivePrefixTreeStrategy createIndexStrategy(String field) {
        RecursivePrefixTreeStrategy s = new RecursivePrefixTreeStrategy(this._grid, field);
        s.setDistErrPct((double)0.2f);
        return s;
    }

    private SerializedDVStrategy createDetailStrategy(String field) {
        return new SerializedSortedSetDVStrategy((SpatialContext)Converter.getSpatialContext(), field);
    }

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return new SortField[]{this.getSortField(property, new Coordinate(0.0, 0.0), reverse)};
    }

    private SortField getSortField(String property, Coordinate fromPoint, boolean reverse) {
        Point zeroPoint = Converter.toShape((Coordinate)fromPoint);
        ValueSource valueSource = this.getStrategy(this.getIndexField(property)).makeDistanceValueSource(zeroPoint);
        SortField sortField = valueSource.getSortField(reverse);
        return sortField;
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        if (Geography.class.isAssignableFrom(parameters.getType())) {
            String property = parameters.getProperty();
            if (parameters instanceof PandoraFilter.Contains) {
                PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
                return this.createFilter(property, (Geography)params.getValue(), SpatialOperation.Contains);
            }
            if (parameters instanceof PandoraFilter.Within) {
                PandoraFilter.Within params = (PandoraFilter.Within)parameters;
                return this.createFilter(property, (Geography)params.getValue(), SpatialOperation.IsWithin);
            }
            if (parameters instanceof PandoraFilter.Intersects) {
                PandoraFilter.Intersects params = (PandoraFilter.Intersects)parameters;
                return this.createFilter(property, (Geography)params.getValue(), SpatialOperation.Intersects);
            }
        }
        return null;
    }

    private Query createFilter(String property, Geography area, SpatialOperation operation) {
        String field = this.getIndexField(property);
        if (area.equals(Tetragon.wholeWorld())) {
            if (operation == SpatialOperation.IsWithin || operation == SpatialOperation.Intersects) {
                return FilterHelper.createNotEmptyFilter(field);
            }
            return FilterHelper.createMatchNothingFilter();
        }
        SpatialArgs args = new SpatialArgs(operation, Converter.toShape((Geography)area));
        args.setDistErrPct(Double.valueOf(0.025f));
        Query roughFilter = this.getStrategy(field).makeQuery(args);
        return roughFilter;
    }
}

