/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractNetworkMessageWriter;
import org.xlightweb.IHttpHeader;
import org.xsocket.DataConverter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

class SimpleMessageWriter
extends AbstractNetworkMessageWriter {
    private static final Logger LOG = Logger.getLogger(SimpleMessageWriter.class.getName());
    private boolean isHeaderWritten = false;
    private final IHttpHeader header;

    public SimpleMessageWriter(AbstractHttpConnection httpConnection, boolean destroyOnClose, IHttpHeader header) throws IOException {
        super(httpConnection, destroyOnClose);
        this.header = header;
    }

    public final void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
        AbstractHttpConnection con = this.getConnection();
        if (con != null) {
            try {
                con.setFlushmode(flushMode);
                int dataWritten = 0;
                if (!this.isHeaderWritten) {
                    this.isHeaderWritten = true;
                    dataWritten = con.write(this.header.toString() + "\r\n");
                    dataWritten += this.writeBody(con, bodyData, completionHandler);
                    con.incCountMessageSent();
                } else {
                    dataWritten = this.writeBody(con, bodyData, completionHandler);
                }
                if (dataWritten > 0) {
                    con.flush();
                }
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by flushing bound data sink. Destroying connection. reason " + DataConverter.toString((Throwable)ioe));
                }
                this.destroy();
                throw ioe;
            }
        }
    }

    protected int writeBody(AbstractHttpConnection con, ByteBuffer[] bodyData, IWriteCompletionHandler completionHandler) throws IOException {
        if (bodyData != null) {
            return (int)con.write(bodyData, completionHandler);
        }
        return 0;
    }

    void onClose(boolean destroyOnClose) throws IOException {
        if (this.getConnection() == null) {
            return;
        }
        this.destroy();
    }

    public final boolean isNetworkEndpoint() {
        return true;
    }
}

