/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.app;

import com.paterva.maltego.java.config.ConfigFileWriter;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.JavaRuntimeSelector;
import com.paterva.maltego.java.config.MemorySelector;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import java.io.File;
import java.util.Map;
import javax.swing.JOptionPane;

public class SilentDetector {
    public void go() {
        Map<String, JavaInfo> javaRuntimes = JavaUtils.detectJavas();
        ConfigOptions options = this.selectOptions(javaRuntimes);
        boolean displayMessage = this.mustDisplayMessage(options);
        if (displayMessage) {
            String newLine = System.lineSeparator();
            String msg = "Please install Java 8, 11, or 17 to run this version of Maltego." + newLine + "Visit docs.maltego.com for support.";
            System.out.println(msg);
            JOptionPane.showMessageDialog(null, msg, "Required Java Version Not Found", 2);
            System.exit(1);
        } else if (options != null) {
            ConfigFileWriter configFile = new ConfigFileWriter();
            configFile.write(options);
        }
    }

    private boolean mustDisplayMessage(ConfigOptions options) {
        boolean displayMessage = false;
        if (options != null) {
            JavaInfo info;
            String javaRuntime = options.getJavaRuntime();
            boolean isValidRuntime = javaRuntime != null && javaRuntime.length() > 0;
            JavaInfo javaInfo = info = !isValidRuntime ? null : JavaUtils.getInfo(new File(javaRuntime));
            if (info == null || !JavaUtils.isValidVersion(info.getVersion())) {
                displayMessage = true;
            }
        } else {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion == null || SilentDetector.isPreJava8(javaVersion)) {
                displayMessage = true;
            }
        }
        return displayMessage;
    }

    public ConfigOptions selectOptions(Map<String, JavaInfo> javaRuntimes) {
        ConfigOptions options = null;
        String selected = new JavaRuntimeSelector().select(javaRuntimes);
        if (selected == null) {
            System.out.println("Warning: Could not find a suitable Java runtime.");
        } else {
            System.out.println("selected java: " + selected);
            int maxMemory = MemorySelector.get(selected).getPrefered();
            System.out.println("selected heap size: " + maxMemory);
            options = new ConfigOptions();
            options.setMaxHeapSize(maxMemory);
            options.setJavaRuntime(selected);
        }
        return options;
    }

    private static boolean isPreJava8(String javaVersion) {
        return javaVersion.startsWith("1.") && !SilentDetector.isJava8(javaVersion);
    }

    private static boolean isJava8(String javaVersion) {
        return javaVersion.startsWith("1.8.");
    }
}

