/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSStringObject
extends JSNonProxyObject {
    private final CharSequence string;

    protected JSStringObject(Shape shape, CharSequence string) {
        super(shape);
        this.string = string;
    }

    public CharSequence getCharSequence() {
        return this.string;
    }

    public static DynamicObject create(Shape shape, CharSequence value) {
        return new JSStringObject(shape, value);
    }

    public static DynamicObject create(JSRealm realm, JSObjectFactory factory, CharSequence value) {
        return factory.initProto(new JSStringObject(factory.getShape(realm), value), realm);
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @ExportMessage
    public boolean isString() {
        return true;
    }

    @ExportMessage
    public String asString() {
        return JSString.getString(this);
    }
}

