/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.typing.types.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class Attachments
extends ArrayList<Attachment> {
    public static final String PROPERTY_DESC_KEY = "property.atts31415237681098";
    private Attachment _primaryImage;

    public Attachments(Attachments atts) {
        super(atts);
        this._primaryImage = atts._primaryImage;
    }

    public Attachments() {
    }

    public Attachments(int initialCapacity) {
        super(initialCapacity);
    }

    public Attachments(Collection<? extends Attachment> c) {
        super(c);
    }

    public Attachment getPrimaryImage() {
        return this._primaryImage;
    }

    public void setPrimaryImage(Attachment att) {
        if (att != null && !this.contains(att)) {
            throw new IllegalArgumentException("Primary image attachment not found.");
        }
        this._primaryImage = att;
    }

    @Override
    public Attachment remove(int index) {
        Attachment att = (Attachment)super.remove(index);
        if (att != null && att.equals(this._primaryImage)) {
            this._primaryImage = null;
        }
        return att;
    }

    @Override
    public boolean remove(Object o) {
        if (o != null && o.equals(this._primaryImage)) {
            this._primaryImage = null;
        }
        return super.remove(o);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        if (!this.contains(this._primaryImage)) {
            this._primaryImage = null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachments other = (Attachments)obj;
        if (!Objects.equals(this._primaryImage, other._primaryImage)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + (this._primaryImage != null ? this._primaryImage.hashCode() : 0);
        return hash;
    }
}

