/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.convert.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphMatchableEntities;
import com.paterva.maltego.typing.TypeDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TabularGraphTypes {
    protected final Map<Integer, TypeDescriptor> _entityColumnTypes;
    protected final Map<Integer, TypeDescriptor> _linkColumnTypes;
    protected final TabularGraphEntityType[] _entityTypes;
    protected final TabularGraphLinkType[] _linkTypes;
    protected final List<String> _entitySpecs = new ArrayList<String>();
    protected final List<TabularGraphMatchableEntities> _matchableEntities;

    public TabularGraphTypes(TabularGraph tabularGraph) {
        List entities = tabularGraph.getEntities();
        List links = tabularGraph.getLinks();
        this._entityColumnTypes = TabularGraphUtils.getDesiredColumnTypes(entities);
        this._linkColumnTypes = TabularGraphUtils.getDesiredColumnTypes(links);
        this._entityTypes = TabularGraphUtils.getEntityTypes(tabularGraph, this._entitySpecs, entities);
        this._linkTypes = TabularGraphUtils.getLinkTypes(tabularGraph, links);
        this._matchableEntities = this.getMatchableEntities(this._entityTypes);
    }

    public Map<Integer, TypeDescriptor> getEntityColumnTypes() {
        return this._entityColumnTypes;
    }

    public Map<Integer, TypeDescriptor> getLinkColumnTypes() {
        return this._linkColumnTypes;
    }

    public TabularGraphEntityType[] getEntityTypes() {
        return this._entityTypes;
    }

    public TabularGraphLinkType[] getLinkTypes() {
        return this._linkTypes;
    }

    public List<TabularGraphMatchableEntities> getMatchableEntities() {
        return this._matchableEntities;
    }

    private List<TabularGraphMatchableEntities> getMatchableEntities(TabularGraphEntityType[] entityTypes) {
        ArrayList<TabularGraphMatchableEntities> matchableEntitiesList = new ArrayList<TabularGraphMatchableEntities>();
        for (TabularGraphEntityType entityType : entityTypes) {
            boolean found = false;
            for (TabularGraphMatchableEntities matchableEntities : matchableEntitiesList) {
                for (TabularGraphEntityType type : matchableEntities.types) {
                    if (!type.equals(entityType)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                matchableEntities.types.add(entityType);
                entityType.matchableEntities = matchableEntities;
                break;
            }
            if (found) continue;
            TabularGraphMatchableEntities matchableEntities = new TabularGraphMatchableEntities();
            matchableEntities.types.add(entityType);
            entityType.matchableEntities = matchableEntities;
            matchableEntitiesList.add(matchableEntities);
        }
        return matchableEntitiesList;
    }
}

