/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.structures;

import com.paterva.maltego.core.LinkID;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class EntityLinks {
    private final Set<LinkID> _incomingModel;
    private final Set<LinkID> _outgoingModel;
    private final Set<LinkID> _incomingView;
    private final Set<LinkID> _outgoingView;

    public EntityLinks() {
        this._incomingModel = new HashSet<LinkID>();
        this._outgoingModel = new HashSet<LinkID>();
        this._incomingView = new HashSet<LinkID>();
        this._outgoingView = new HashSet<LinkID>();
    }

    public EntityLinks(EntityLinks links) {
        this._incomingModel = new HashSet<LinkID>(links._incomingModel);
        this._outgoingModel = new HashSet<LinkID>(links._outgoingModel);
        this._incomingView = new HashSet<LinkID>(links._incomingView);
        this._outgoingView = new HashSet<LinkID>(links._outgoingView);
    }

    public EntityLinks(Set<LinkID> incomingModel, Set<LinkID> outgoingModel, Set<LinkID> incomingView, Set<LinkID> outgoingView) {
        if (incomingModel == null || outgoingModel == null || incomingView == null || outgoingView == null) {
            throw new IllegalArgumentException("Link sets may not be null");
        }
        this._incomingModel = incomingModel;
        this._outgoingModel = outgoingModel;
        this._incomingView = incomingView;
        this._outgoingView = outgoingView;
    }

    public Set<LinkID> getModelIncomingLinks() {
        return this._incomingModel;
    }

    public Set<LinkID> getModelOutgoingLinks() {
        return this._outgoingModel;
    }

    public Set<LinkID> getViewIncomingLinks() {
        return this._incomingView;
    }

    public Set<LinkID> getViewOutgoingLinks() {
        return this._outgoingView;
    }

    public boolean isViewAndModelIncomingLinksDifferent() {
        return this._incomingModel.size() != this._incomingView.size() || !this._incomingModel.containsAll(this._incomingView);
    }

    public boolean isViewAndModelOutgoingLinksDifferent() {
        return this._outgoingModel.size() != this._outgoingView.size() || !this._outgoingModel.containsAll(this._outgoingView);
    }

    public boolean isViewAndModelLinksDifferent() {
        return this.isViewAndModelIncomingLinksDifferent() && this.isViewAndModelOutgoingLinksDifferent();
    }

    public Set<LinkID> getModelLinks() {
        HashSet<LinkID> allLinks = new HashSet<LinkID>();
        allLinks.addAll(this._incomingModel);
        allLinks.addAll(this._outgoingModel);
        return Collections.unmodifiableSet(allLinks);
    }

    public Set<LinkID> getViewLinks() {
        HashSet<LinkID> allLinks = new HashSet<LinkID>();
        allLinks.addAll(this._incomingView);
        allLinks.addAll(this._outgoingView);
        return Collections.unmodifiableSet(allLinks);
    }

    public Set<LinkID> getViewOnlyIncoming() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._incomingView);
        links.removeAll(this._incomingModel);
        return links;
    }

    public Set<LinkID> getViewOnlyOutgoing() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._outgoingView);
        links.removeAll(this._outgoingModel);
        return links;
    }

    public Set<LinkID> getViewOnlyLinks() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._incomingView);
        links.addAll(this._outgoingView);
        links.removeAll(this._incomingModel);
        links.removeAll(this._outgoingModel);
        return links;
    }

    public Set<LinkID> getModelOnlyIncoming() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._incomingModel);
        links.removeAll(this._incomingView);
        return links;
    }

    public Set<LinkID> getModelOnlyOutgoing() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._outgoingModel);
        links.removeAll(this._outgoingView);
        return links;
    }

    public Set<LinkID> getModelOnlyLinks() {
        HashSet<LinkID> links = new HashSet<LinkID>(this._incomingModel);
        links.addAll(this._outgoingModel);
        links.removeAll(this._incomingView);
        links.removeAll(this._outgoingView);
        return links;
    }

    public int getModelLinkCount() {
        return this.getModelIncomingCount() + this.getModelOutgoingCount();
    }

    public int getModelIncomingCount() {
        return this._incomingModel.size();
    }

    public int getModelOutgoingCount() {
        return this._outgoingModel.size();
    }

    public int getViewLinkCount() {
        return this.getViewIncomingCount() + this.getViewOutgoingCount();
    }

    public int getViewIncomingCount() {
        return this._incomingView.size();
    }

    public int getViewOutgoingCount() {
        return this._outgoingView.size();
    }

    public boolean hasViewLinks() {
        return this.hasViewIncomingLinks() || this.hasViewOutgoingLinks();
    }

    public boolean hasViewIncomingLinks() {
        return this.getViewIncomingCount() != 0;
    }

    public boolean hasViewOutgoingLinks() {
        return this.getViewOutgoingCount() != 0;
    }

    public boolean hasModelLinks() {
        return this.hasModelIncomingLinks() || this.hasModelOutgoingLinks();
    }

    public boolean hasModelIncomingLinks() {
        return this.getModelIncomingCount() != 0;
    }

    public boolean hasModelOutgoingLinks() {
        return this.getModelOutgoingCount() != 0;
    }

    public boolean hasViewOrModelLinks() {
        return this.hasViewLinks() || this.hasModelLinks();
    }

    public String toString() {
        return "EntityLinks{_incomingModel=" + this._incomingModel + ", _outgoingModel=" + this._outgoingModel + ", _incomingView=" + this._incomingView + ", _outgoingView=" + this._outgoingView + '}';
    }

    public void clear() {
        this.clearView();
        this.clearModel();
    }

    public void clearModel() {
        this._incomingModel.clear();
        this._outgoingModel.clear();
    }

    public void clearView() {
        this._incomingView.clear();
        this._outgoingView.clear();
    }

    public void clearIncoming() {
        this._incomingModel.clear();
        this._incomingView.clear();
    }

    public void clearOutgoing() {
        this._outgoingModel.clear();
        this._outgoingView.clear();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this._incomingModel);
        hash = 37 * hash + Objects.hashCode(this._outgoingModel);
        hash = 37 * hash + Objects.hashCode(this._incomingView);
        hash = 37 * hash + Objects.hashCode(this._outgoingView);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityLinks other = (EntityLinks)obj;
        if (!Objects.equals(this._incomingModel, other._incomingModel)) {
            return false;
        }
        if (!Objects.equals(this._outgoingModel, other._outgoingModel)) {
            return false;
        }
        if (!Objects.equals(this._incomingView, other._incomingView)) {
            return false;
        }
        return Objects.equals(this._outgoingView, other._outgoingView);
    }
}

