/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.plaf.LayerUI;

public class DisableInputLayerUI
extends LayerUI<JPanel> {
    private boolean isRunning = false;

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (!this.isRunning) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2.setPaint(Color.GRAY);
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        g2.dispose();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JLayer jlayer = (JLayer)c;
        jlayer.setLayerEventMask(56L);
    }

    @Override
    public void uninstallUI(JComponent c) {
        JLayer jlayer = (JLayer)c;
        jlayer.setLayerEventMask(0L);
        super.uninstallUI(c);
    }

    @Override
    public void eventDispatched(AWTEvent e, JLayer l) {
        if (this.isRunning && e instanceof InputEvent) {
            ((InputEvent)e).consume();
        }
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.isRunning = false;
            this.firePropertyChange("repaint", 0, 1);
        } else {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            this.firePropertyChange("repaint", 0, 1);
        }
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent pce, JLayer l) {
        if ("repaint".equals(pce.getPropertyName())) {
            l.repaint();
        }
    }
}

