/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.dialog.ProgressComponent;
import com.paterva.maltego.util.ui.dialog.ProgressControl;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class ProgressController<TData, TComponent extends Component>
extends ValidatingController<Component>
implements WizardNavigationSupport {
    private static final Logger LOG = Logger.getLogger(ProgressController.class.getName());
    private RequestProcessor _rp;
    private boolean _busy = false;
    private RequestProcessor.Task _task;
    private TComponent _displayComponent;
    private final Object _busyLock = "myLock";
    private ProgressComponent _progressComponent;

    @Override
    protected Component createComponent() {
        CardLayout layout = new CardLayout();
        JPanel panel = new JPanel(layout);
        this._displayComponent = this.createDisplayComponent();
        this._progressComponent = this.createProgressComponent();
        panel.add((Component)this._displayComponent, "display");
        panel.add((Component)((Object)this._progressComponent), "progress");
        layout.show(panel, "progress");
        return panel;
    }

    protected abstract TComponent createDisplayComponent();

    protected ProgressComponent createProgressComponent() {
        return new ProgressControl();
    }

    protected static Component createProgressBar(ProgressHandle handle, boolean showDetail) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JLabel main = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detail = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        detail.setText(" ");
        main.setText(" ");
        main.setHorizontalAlignment(2);
        detail.setHorizontalAlignment(4);
        panel.add((Component)main, "North");
        if (showDetail) {
            panel.add((Component)detail, "South");
        }
        panel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)handle), "Center");
        return panel;
    }

    @Override
    protected String getFirstError(Component component) {
        return this._busy ? "Busy... Please wait..." : null;
    }

    private void start() {
        if (this.acquireLock()) {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Busy... Please wait...");
            this._progressComponent.setProgressComponent(ProgressController.createProgressBar(handle, true));
            JPanel panel = (JPanel)this.component();
            CardLayout layout = (CardLayout)((JPanel)this.component()).getLayout();
            layout.show(panel, "progress");
            this._task = this.processor().create(() -> {
                try {
                    handle.start();
                    handle.progress("Initializing...");
                    TData result = this.doProcessing(this.getDescriptor(), handle);
                    try {
                        SwingUtilities.invokeAndWait(() -> this.processingCompleted(this.getDescriptor(), this._displayComponent, result));
                    }
                    catch (InterruptedException ex) {
                        LOG.info("Progress canceled");
                    }
                }
                catch (Exception e) {
                    NormalException.logStackTrace((Throwable)e);
                    try {
                        SwingUtilities.invokeAndWait(() -> this.processingFailed(this._displayComponent, e));
                    }
                    catch (InterruptedException ex) {
                        LOG.info("Progress canceled");
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    handle.finish();
                    this.releaseLock();
                    this.showDisplayComponent();
                }
            });
            this._task.schedule(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLock() {
        boolean success;
        Object object = this._busyLock;
        synchronized (object) {
            if (!this._busy) {
                this._busy = true;
                success = true;
            } else {
                success = false;
            }
        }
        this.doValidate();
        this.fireNavigationChanged();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock() {
        Object object = this._busyLock;
        synchronized (object) {
            this._busy = false;
        }
        this._task = null;
        this.fireNavigationChanged();
    }

    private void showDisplayComponent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent panel = (JComponent)ProgressController.this.component();
                CardLayout layout = (CardLayout)panel.getLayout();
                layout.show(panel, "display");
                ProgressController.this.doValidate();
            }
        });
    }

    protected abstract TData doProcessing(WizardDescriptor var1, ProgressHandle var2) throws Exception;

    protected abstract void processingCompleted(WizardDescriptor var1, TComponent var2, TData var3);

    protected abstract void processingFailed(TComponent var1, Exception var2);

    private RequestProcessor processor() {
        if (this._rp == null) {
            this._rp = new RequestProcessor("wizard", 1, true, true);
        }
        return this._rp;
    }

    @Override
    protected void readSettings(WizardDescriptor settings) {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeSettings(WizardDescriptor settings) {
        Object object = this._busyLock;
        synchronized (object) {
            if (this._busy) {
                this._task.cancel();
            }
        }
    }

    protected TComponent getDisplayComponent() {
        return this._displayComponent;
    }

    protected boolean allowBackWhileBusy() {
        return false;
    }

    @Override
    public boolean canBack() {
        return this.allowBackWhileBusy() || !this._busy;
    }
}

