/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab;

import com.paterva.maltego.collab.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlPullParserUtils {
    public static String toString(XmlPullParser parser) throws XmlPullParserException, IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            XmlPullParserUtils.toXml(parser, os);
        }
        return os.toString();
    }

    public static void toXml(XmlPullParser parser, OutputStream stream) throws XmlPullParserException, IOException {
        XmlPullParserUtils.toXml(parser, stream, true);
    }

    public static void toXml(XmlPullParser parser, OutputStream stream, boolean useCurrentTag) throws XmlPullParserException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        XmlPullParserUtils.toXml(parser, writer, useCurrentTag);
        ((Writer)writer).flush();
    }

    public static String toXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        String result = XmlPullParserUtils.toXml(parser, true);
        return result;
    }

    public static String toXml(XmlPullParser parser, boolean useCurrentTag) throws XmlPullParserException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmlPullParserUtils.toXml(parser, os);
        os.close();
        return os.toString();
    }

    public static void toXml(XmlPullParser parser, Writer writer) throws XmlPullParserException, IOException {
        XmlPullParserUtils.toXml(parser, writer, true);
    }

    public static void toXml(XmlPullParser parser, Writer writer, boolean useCurrentTag) throws XmlPullParserException, IOException {
        boolean stop;
        int startDepth = parser.getDepth();
        int previousEvent = -1;
        StringBuilder lastStartTag = new StringBuilder();
        boolean firstTagIsText = parser.getEventType() == 4;
        int event = useCurrentTag ? parser.getEventType() : parser.next();
        boolean bl = stop = event == 3;
        while (event != 1 && !stop) {
            switch (event) {
                case 2: {
                    XmlPullParserUtils.flushStartTag(lastStartTag, writer);
                    lastStartTag = XmlPullParserUtils.createStartTag(parser);
                    break;
                }
                case 3: {
                    boolean bl2 = stop = startDepth == parser.getDepth();
                    if (stop && firstTagIsText) break;
                    if (previousEvent == 2) {
                        XmlPullParserUtils.addEndTag(lastStartTag);
                        lastStartTag = XmlPullParserUtils.flushStartTag(lastStartTag, writer);
                        break;
                    }
                    lastStartTag = XmlPullParserUtils.flushStartTag(lastStartTag, writer);
                    XmlPullParserUtils.write(writer, XmlPullParserUtils.createNestedEndTag(parser));
                    break;
                }
                case 9: {
                    lastStartTag = XmlPullParserUtils.flushStartTag(lastStartTag, writer);
                    XmlPullParserUtils.write(writer, String.format("<!--%s-->", parser.getText()));
                    break;
                }
                case 4: {
                    lastStartTag = XmlPullParserUtils.flushStartTag(lastStartTag, writer);
                    XmlPullParserUtils.write(writer, XmlUtil.escape(parser.getText()));
                }
            }
            previousEvent = parser.getEventType();
            if (stop) continue;
            event = parser.next();
        }
    }

    private static void addEndTag(StringBuilder startTag) {
        startTag.deleteCharAt(startTag.length() - 1);
        startTag.append("/>");
    }

    private static StringBuilder flushStartTag(StringBuilder tag, Writer writer) throws IOException {
        if (tag != null) {
            XmlPullParserUtils.write(writer, tag.toString());
        }
        return null;
    }

    private static void write(Writer writer, String text) throws IOException {
        writer.append(text);
    }

    private static StringBuilder createStartTag(XmlPullParser parser) throws XmlPullParserException {
        StringBuilder buffer = new StringBuilder("<");
        buffer.append(XmlPullParserUtils.getName(parser));
        XmlPullParserUtils.appendNamespaces(parser, buffer);
        XmlPullParserUtils.appendAttributes(parser, buffer);
        buffer.append(">");
        return buffer;
    }

    private static String createNestedEndTag(XmlPullParser parser) {
        return String.format("</%s>", XmlPullParserUtils.getName(parser));
    }

    private static String getName(XmlPullParser parser) {
        return XmlPullParserUtils.getName(parser.getName(), parser.getPrefix());
    }

    private static String getName(String name, String prefix) {
        if (prefix == null) {
            return name;
        }
        return String.format("%s:%s", prefix, name);
    }

    private static void appendNamespaces(XmlPullParser parser, StringBuilder writer) throws XmlPullParserException {
        int nsStart = parser.getNamespaceCount(parser.getDepth() - 1);
        int nsEnd = parser.getNamespaceCount(parser.getDepth());
        for (int i = nsStart; i < nsEnd; ++i) {
            String prefix = parser.getNamespacePrefix(i);
            String ns = parser.getNamespaceUri(i);
            prefix = prefix == null ? "xmlns" : "xmlns:" + prefix;
            writer.append(String.format(" %s=\"%s\"", prefix, ns));
        }
    }

    private static void appendAttributes(XmlPullParser parser, StringBuilder writer) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String prefix = parser.getAttributePrefix(i);
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            writer.append(String.format(" %s=\"%s\"", XmlPullParserUtils.getName(name, prefix), XmlUtil.escape(value)));
        }
    }
}

