/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.XmlPullParserUtils;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppEndpointEvent;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppEndpointListener;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppPacket;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.Queue;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class XmppEndpoint {
    private boolean _started = false;
    private boolean _stopRequested = false;
    private final OutputStreamWriter _writer;
    private final InputStream _is;
    private final LinkedList<XmppEndpointListener> _listeners = new LinkedList();
    private final Queue<String> _outputQueue = new LinkedList<String>();

    public XmppEndpoint(InputStream is, OutputStream os) {
        this._is = is;
        this._writer = new OutputStreamWriter(os);
    }

    public synchronized void start() throws IOException {
        if (!this._started) {
            Thread receiveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XmppEndpoint.this.processInput();
                        XmppEndpoint.this._is.close();
                        XmppEndpoint.this.close();
                    }
                    catch (IOException ex) {
                        NormalException.showStackTrace((Throwable)ex);
                    }
                }
            });
            receiveThread.setDaemon(true);
            receiveThread.start();
            Thread sendThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XmppEndpoint.this.processOutput();
                        XmppEndpoint.this._writer.close();
                    }
                    catch (IOException ex) {
                        NormalException.showStackTrace((Throwable)ex);
                    }
                }
            });
            sendThread.setDaemon(true);
            sendThread.start();
        }
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(String s) {
        Queue<String> queue = this._outputQueue;
        synchronized (queue) {
            this._outputQueue.add(s);
            this._outputQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._started) {
            this._stopRequested = true;
            Queue<String> queue = this._outputQueue;
            synchronized (queue) {
                this._started = false;
                this._outputQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutput() throws IOException {
        while (!this._stopRequested) {
            Queue<String> queue = this._outputQueue;
            synchronized (queue) {
                try {
                    this._outputQueue.wait();
                    while (!this._outputQueue.isEmpty() && !this._stopRequested) {
                        String packet = this._outputQueue.remove();
                        this._writer.write(packet);
                        this._writer.flush();
                    }
                }
                catch (InterruptedException ex) {
                    NormalException.showStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void processInput() throws IOException {
        boolean endStream = false;
        try {
            int event;
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(this._is, "UTF-8");
            do {
                if ((event = parser.next()) == 2) {
                    if (XmppEndpoint.isStream((XmlPullParser)parser)) {
                        this.fireEvent(new XmppPacket(1));
                        continue;
                    }
                    String stanza = XmlPullParserUtils.toXml((XmlPullParser)parser);
                    this.fireEvent(new XmppPacket(stanza));
                    continue;
                }
                if (event != 3 || !XmppEndpoint.isStream((XmlPullParser)parser)) continue;
                endStream = true;
                this.fireEvent(new XmppPacket(2));
            } while (!this._stopRequested && !endStream && event != 1);
        }
        catch (XmlPullParserException ex) {
            throw new IOException("Error parsing client stream", ex);
        }
    }

    private static boolean isStream(XmlPullParser parser) {
        return "stream".equals(parser.getName()) && "http://etherx.jabber.org/streams".equals(parser.getNamespace());
    }

    public void addEndpointListener(XmppEndpointListener listener) {
        this._listeners.add(listener);
    }

    public void removeEndpointListener(XmppEndpointListener listener) {
        this._listeners.remove(listener);
    }

    private void fireEvent(XmppPacket packet) {
        XmppEndpointEvent event = new XmppEndpointEvent(this, packet);
        for (XmppEndpointListener listener : this._listeners) {
            listener.packetReceived(event);
        }
    }
}

