/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.editors.PropertyFactory;
import com.paterva.maltego.util.StringUtilities;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

public class PropertySheetFactory {
    public static PropertySheetFactory _default;
    private PropertyFactory _propertyFactory;

    public PropertySheetFactory(PropertyFactory propertyFactory) {
        this._propertyFactory = propertyFactory;
    }

    public static synchronized PropertySheetFactory getDefault() {
        if (_default == null && (_default = (PropertySheetFactory)Lookup.getDefault().lookup(PropertySheetFactory.class)) == null) {
            _default = new PropertySheetFactory(PropertyFactory.getDefault());
        }
        return _default;
    }

    public static Sheet createDefaultSheet() {
        Sheet sheet = Sheet.createDefault();
        sheet.put(PropertySheetFactory.createDefaultSet());
        return sheet;
    }

    private static Sheet.Set getGroup(GroupDefinitions groups, Sheet sheet, String group, Sheet.Set defaultSet) {
        Sheet.Set set;
        if (group == null) {
            group = "";
        }
        if ((set = sheet.get(group)) == null) {
            set = PropertySheetFactory.createGroup(groups, group, defaultSet);
            sheet.put(set);
        }
        return set;
    }

    public Sheet createSheet(DataSource data, DisplayDescriptorEnumeration descriptors, GroupDefinitions groups) {
        Sheet sheet = PropertySheetFactory.createDefaultSheet();
        this.addProperties(sheet, data, descriptors, groups);
        return sheet;
    }

    public void addProperties(Sheet sheet, DataSource data, DisplayDescriptorEnumeration descriptors, GroupDefinitions groups) {
        for (DisplayDescriptor descriptor : descriptors) {
            try {
                this.addProperty(sheet, descriptor, data, groups);
            }
            catch (UnsupportedEditorException ex) {
                Logger.getLogger(PropertySheetFactory.class.getName()).log(Level.SEVERE, "Could not create property editor", ex);
            }
        }
    }

    public void addProperty(Sheet sheet, DisplayDescriptor descriptor, DataSource data, GroupDefinitions groups) throws UnsupportedEditorException {
        Sheet.Set set = PropertySheetFactory.getGroup(groups, sheet, descriptor.getGroupName(), PropertySheetFactory.createDefaultSet());
        Node.Property p = this._propertyFactory.createProperty(descriptor, data);
        set.put(p);
    }

    public void addProperty(Sheet sheet, DisplayDescriptor descriptor, DataSource data, GroupDefinitions groups, Sheet.Set defaultSet) throws UnsupportedEditorException {
        Sheet.Set set = PropertySheetFactory.getGroup(groups, sheet, descriptor.getGroupName(), defaultSet);
        Node.Property p = this._propertyFactory.createProperty(descriptor, data);
        set.put(p);
    }

    protected static Sheet.Set createGroup(GroupDefinitions groups, String groupName, Sheet.Set defaultSet) {
        Sheet.Set set;
        if (StringUtilities.isNullOrEmpty((String)groupName)) {
            set = defaultSet;
        } else {
            Group group = null;
            if (groups != null) {
                group = groups.getTopLevelGroups().get(groupName);
            }
            set = group == null ? PropertySheetFactory.createSet(groupName, groupName, "") : PropertySheetFactory.createSet(group.getName(), group.getDisplayName(), group.getDescription());
        }
        return set;
    }

    private static Sheet.Set createSet(String name, String displayName, String description) {
        Sheet.Set set = Sheet.createPropertiesSet();
        set.setName(name);
        set.setDisplayName(displayName);
        set.setShortDescription(description);
        return set;
    }

    private static Sheet.Set createDefaultSet() {
        return PropertySheetFactory.createSet("", "Properties", "Collection of properties");
    }

    public static Sheet.Set getSet(Sheet sheet, String name, String displayName, String description) {
        Sheet.Set set = sheet.get(name);
        if (set == null) {
            set = PropertySheetFactory.createSet(name, displayName, description);
            sheet.put(set);
        }
        return set;
    }
}

