/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io.jts;

import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.io.WKTReader;
import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JtsWKTReader
extends WKTReader {
    protected final JtsSpatialContext ctx;

    public JtsWKTReader(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
        this.ctx = ctx;
    }

    public DatelineRule getDatelineRule() {
        return this.ctx.getDatelineRule();
    }

    @Override
    protected Shape parseShapeByType(WKTReader.State state, String shapeType) throws ParseException {
        if (shapeType.equalsIgnoreCase("POLYGON")) {
            return this.parsePolygonShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.parseMulitPolygonShape(state);
        }
        return super.parseShapeByType(state, shapeType);
    }

    @Override
    protected Shape parseLineStringShape(WKTReader.State state) throws ParseException {
        if (!this.ctx.useJtsLineString()) {
            return super.parseLineStringShape(state);
        }
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeLineString(Collections.emptyList());
        }
        GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
        Coordinate[] coordinates = this.coordinateSequence(state);
        return this.ctx.makeShapeFromGeometry((Geometry)geometryFactory.createLineString(coordinates));
    }

    protected Shape parsePolygonShape(WKTReader.State state) throws ParseException {
        Polygon geometry;
        if (state.nextIfEmptyAndSkipZM()) {
            GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
            geometry = geometryFactory.createPolygon(geometryFactory.createLinearRing(new Coordinate[0]), null);
        } else {
            geometry = this.polygon(state);
            if (geometry.isRectangle()) {
                return this.ctx.makeRectFromRectangularPoly((Geometry)geometry);
            }
        }
        return this.ctx.makeShapeFromGeometry((Geometry)geometry);
    }

    protected Polygon polygon(WKTReader.State state) throws ParseException {
        GeometryFactory geometryFactory = this.ctx.getGeometryFactory();
        List<Coordinate[]> coordinateSequenceList = this.coordinateSequenceList(state);
        LinearRing shell = geometryFactory.createLinearRing(coordinateSequenceList.get(0));
        LinearRing[] holes = null;
        if (coordinateSequenceList.size() > 1) {
            holes = new LinearRing[coordinateSequenceList.size() - 1];
            for (int i = 1; i < coordinateSequenceList.size(); ++i) {
                holes[i - 1] = geometryFactory.createLinearRing(coordinateSequenceList.get(i));
            }
        }
        return geometryFactory.createPolygon(shell, holes);
    }

    protected Shape parseMulitPolygonShape(WKTReader.State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeCollection(Collections.EMPTY_LIST);
        }
        ArrayList<Shape> polygons = new ArrayList<Shape>();
        state.nextExpect('(');
        do {
            polygons.add(this.parsePolygonShape(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return this.ctx.makeCollection(polygons);
    }

    protected List<Coordinate[]> coordinateSequenceList(WKTReader.State state) throws ParseException {
        ArrayList<Coordinate[]> sequenceList = new ArrayList<Coordinate[]>();
        state.nextExpect('(');
        do {
            sequenceList.add(this.coordinateSequence(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return sequenceList;
    }

    protected Coordinate[] coordinateSequence(WKTReader.State state) throws ParseException {
        ArrayList<Coordinate> sequence = new ArrayList<Coordinate>();
        state.nextExpect('(');
        do {
            sequence.add(this.coordinate(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return sequence.toArray(new Coordinate[sequence.size()]);
    }

    protected Coordinate coordinate(WKTReader.State state) throws ParseException {
        double x = this.ctx.normX(state.nextDouble());
        this.ctx.verifyX(x);
        double y = this.ctx.normY(state.nextDouble());
        this.ctx.verifyY(y);
        state.skipNextDoubles();
        return new Coordinate(x, y);
    }

    @Override
    protected double normDist(double v) {
        return this.ctx.getGeometryFactory().getPrecisionModel().makePrecise(v);
    }
}

