/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.ComplexArrayFieldSplitter;
import com.pinkmatter.pandora.lucene.serialize.DocumentProperty;
import com.pinkmatter.pandora.lucene.serialize.DocumentPropertyCollector;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexTypeConverter<T>
extends AbstractTypeConverter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ComplexTypeConverter.class);

    public ComplexTypeConverter(String typeName, Class<? extends T> clazz) {
        super(typeName, clazz);
    }

    protected void writeChild(String field, String childProperty, Object childValue, Document to) throws PandoraException {
        if (childValue != null) {
            TypeConverter.assertValidPropertyName(childProperty);
            String childField = this.getQualifiedChildProperty(field, childProperty);
            TypeConverter converter = TypeConverter.get(childValue);
            if (converter == null) {
                throw new PandoraException(String.format("Could not find a TypeConverter for property %s, value %s, type %s of complex field %s.", childProperty, childValue, childValue.getClass(), field));
            }
            converter.write(childValue, childField, to);
        }
    }

    @Override
    protected T readImpl(IndexableField field) throws PandoraException {
        throw new UnsupportedOperationException();
    }

    public boolean canReadChildSubset() {
        return false;
    }

    @Override
    public Object read(List<IndexableField> from, String prefix) throws PandoraException {
        if (from == null || from.isEmpty()) {
            return null;
        }
        try {
            String mapName = this.getParentField(from.get(0).name(), prefix);
            ComplexArrayFieldSplitter splitter = new ComplexArrayFieldSplitter();
            splitter.collectAll(from, mapName);
            if (splitter.hasArray()) {
                LOG.debug("Reading complex array fields: {}, prefix: {}", (Object)mapName, (Object)prefix);
                Object values = this.createArray(splitter.getContainers().size());
                int i = 0;
                for (ComplexArrayFieldSplitter.Container container : splitter.getContainers()) {
                    Object value = this.readComplexImpl(container.getFields(), prefix);
                    Array.set(values, i, value);
                    ++i;
                }
                return values;
            }
            LOG.debug("Reading complex fields: {}, prefix: {}", (Object)mapName, (Object)prefix);
            Object value = this.readComplexImpl(splitter.getContainers().get(0).getFields(), prefix);
            return value;
        }
        catch (PandoraException ex) {
            throw new PandoraException(String.format("Error reading complex field: %s with prefix: %s using converter: %s.", from.get(0).name(), prefix, this.getType()), (Throwable)ex);
        }
    }

    protected abstract Object readComplexImpl(List<IndexableField> var1, String var2) throws PandoraException;

    protected Map<String, Object> readChildrenAsMap(List<IndexableField> fields, String prefix) throws PandoraException {
        String mapName = "";
        if (!fields.isEmpty()) {
            mapName = this.getParentField(fields.get(0).name(), prefix);
        }
        DocumentPropertyCollector collector = new DocumentPropertyCollector();
        collector.collectAll(fields, mapName);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(collector.getProperties().size() + 1, 1.0f, false);
        for (DocumentProperty property : collector.getProperties()) {
            Object value = property.read();
            map.put(property.getName(), value);
        }
        return map;
    }

    protected String getQualifiedChildProperty(String property, String childProperty) {
        StringBuilder builder = new StringBuilder(this.getIndexField(property));
        builder.append("|");
        builder.append(childProperty);
        return builder.toString();
    }

    public String getParentField(String field, String prefix) throws PandoraException {
        int pos = field.indexOf("|", prefix.length());
        return field.substring(0, pos + 1);
    }

    @Override
    protected Query createEmptyFilter(String property) throws PandoraException {
        return this.createEmptyFilterImpl(property);
    }

    protected abstract Query createEmptyFilterImpl(String var1) throws PandoraException;

    @Override
    protected Query createNotEmptyFilter(String property) throws PandoraException {
        return this.createNotEmptyFilterImpl(property);
    }

    protected abstract Query createNotEmptyFilterImpl(String var1) throws PandoraException;
}

