/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.BasicAuthRequestAuthenticator;
import org.keycloak.adapters.BearerTokenRequestAuthenticator;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.QueryParameterTokenRequestAuthenticator;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;

public abstract class RequestAuthenticator {
    protected static Logger log = Logger.getLogger(RequestAuthenticator.class);
    protected HttpFacade facade;
    protected AuthChallenge challenge;
    protected KeycloakDeployment deployment;
    protected AdapterTokenStore tokenStore;
    protected int sslRedirectPort;

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore, int sslRedirectPort) {
        this.facade = facade;
        this.deployment = deployment;
        this.tokenStore = tokenStore;
        this.sslRedirectPort = sslRedirectPort;
    }

    public RequestAuthenticator(HttpFacade facade, KeycloakDeployment deployment) {
        this.facade = facade;
        this.deployment = deployment;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public AuthOutcome authenticate() {
        AuthOutcome outcome;
        if (log.isTraceEnabled()) {
            log.trace((Object)"--> authenticate()");
        }
        BearerTokenRequestAuthenticator bearer = this.createBearerTokenAuthenticator();
        if (log.isTraceEnabled()) {
            log.trace((Object)"try bearer");
        }
        if ((outcome = bearer.authenticate(this.facade)) == AuthOutcome.FAILED) {
            this.challenge = bearer.getChallenge();
            log.debug((Object)"Bearer FAILED");
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            this.completeAuthentication(bearer, "KEYCLOAK");
            log.debug((Object)"Bearer AUTHENTICATED");
            return AuthOutcome.AUTHENTICATED;
        }
        QueryParameterTokenRequestAuthenticator queryParamAuth = this.createQueryParameterTokenRequestAuthenticator();
        if (log.isTraceEnabled()) {
            log.trace((Object)"try query parameter auth");
        }
        if ((outcome = queryParamAuth.authenticate(this.facade)) == AuthOutcome.FAILED) {
            this.challenge = queryParamAuth.getChallenge();
            log.debug((Object)"QueryParamAuth auth FAILED");
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.AUTHENTICATED) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"QueryParamAuth AUTHENTICATED");
            this.completeAuthentication(queryParamAuth, "KEYCLOAK");
            return AuthOutcome.AUTHENTICATED;
        }
        if (this.deployment.isEnableBasicAuth()) {
            BasicAuthRequestAuthenticator basicAuth = this.createBasicAuthAuthenticator();
            if (log.isTraceEnabled()) {
                log.trace((Object)"try basic auth");
            }
            if ((outcome = basicAuth.authenticate(this.facade)) == AuthOutcome.FAILED) {
                this.challenge = basicAuth.getChallenge();
                log.debug((Object)"BasicAuth FAILED");
                return AuthOutcome.FAILED;
            }
            if (outcome == AuthOutcome.AUTHENTICATED) {
                if (this.verifySSL()) {
                    return AuthOutcome.FAILED;
                }
                log.debug((Object)"BasicAuth AUTHENTICATED");
                this.completeAuthentication(basicAuth, "BASIC");
                return AuthOutcome.AUTHENTICATED;
            }
        }
        if (this.deployment.isBearerOnly()) {
            this.challenge = bearer.getChallenge();
            log.debug((Object)"NOT_ATTEMPTED: bearer only");
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.isAutodetectedBearerOnly(this.facade.getRequest())) {
            this.challenge = bearer.getChallenge();
            log.debug((Object)"NOT_ATTEMPTED: Treating as bearer only");
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"try oauth");
        }
        if (this.tokenStore.isCached(this)) {
            if (this.verifySSL()) {
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"AUTHENTICATED: was cached");
            return AuthOutcome.AUTHENTICATED;
        }
        OAuthRequestAuthenticator oauth = this.createOAuthAuthenticator();
        outcome = oauth.authenticate();
        if (outcome == AuthOutcome.FAILED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.FAILED;
        }
        if (outcome == AuthOutcome.NOT_ATTEMPTED) {
            this.challenge = oauth.getChallenge();
            return AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.verifySSL()) {
            return AuthOutcome.FAILED;
        }
        this.completeAuthentication(oauth);
        this.facade.getResponse().setHeader("Location", oauth.getStrippedOauthParametersRequestUri());
        this.facade.getResponse().setStatus(302);
        this.facade.getResponse().end();
        log.debug((Object)"AUTHENTICATED");
        return AuthOutcome.AUTHENTICATED;
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.warnf("SSL is required to authenticate. Remote address %s is secure: %s, SSL required for: %s .", (Object)this.facade.getRequest().getRemoteAddr(), (Object)this.facade.getRequest().isSecure(), (Object)this.deployment.getSslRequired().name());
            return true;
        }
        return false;
    }

    protected boolean isAutodetectedBearerOnly(HttpFacade.Request request) {
        if (!this.deployment.isAutodetectBearerOnly()) {
            return false;
        }
        String headerValue = this.facade.getRequest().getHeader("X-Requested-With");
        if (headerValue != null && headerValue.equalsIgnoreCase("XMLHttpRequest")) {
            return true;
        }
        headerValue = this.facade.getRequest().getHeader("Faces-Request");
        if (headerValue != null && headerValue.startsWith("partial/")) {
            return true;
        }
        headerValue = this.facade.getRequest().getHeader("SOAPAction");
        if (headerValue != null) {
            return true;
        }
        List<String> accepts = this.facade.getRequest().getHeaders("Accept");
        if (accepts == null) {
            accepts = Collections.emptyList();
        }
        for (String accept : accepts) {
            if (!accept.contains("text/html") && !accept.contains("text/*") && !accept.contains("*/*")) continue;
            return false;
        }
        return true;
    }

    protected abstract OAuthRequestAuthenticator createOAuthAuthenticator();

    protected BearerTokenRequestAuthenticator createBearerTokenAuthenticator() {
        return new BearerTokenRequestAuthenticator(this.deployment);
    }

    protected BasicAuthRequestAuthenticator createBasicAuthAuthenticator() {
        return new BasicAuthRequestAuthenticator(this.deployment);
    }

    protected QueryParameterTokenRequestAuthenticator createQueryParameterTokenRequestAuthenticator() {
        return new QueryParameterTokenRequestAuthenticator(this.deployment);
    }

    protected void completeAuthentication(OAuthRequestAuthenticator oauth) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, this.tokenStore, oauth.getTokenString(), oauth.getToken(), oauth.getIdTokenString(), oauth.getIdToken(), oauth.getRefreshToken());
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName(this.deployment, oauth.getToken()), (KeycloakSecurityContext)session);
        this.completeOAuthAuthentication((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal);
        log.debugv("User ''{0}'' invoking ''{1}'' on client ''{2}''", (Object)principal.getName(), (Object)this.facade.getRequest().getURI(), (Object)this.deployment.getResourceName());
    }

    protected abstract void completeOAuthAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> var1);

    protected abstract void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> var1, String var2);

    protected abstract String changeHttpSessionId(boolean var1);

    protected void completeAuthentication(BearerTokenRequestAuthenticator bearer, String method) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(this.deployment, null, bearer.getTokenString(), bearer.getToken(), null, null, null);
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName(this.deployment, bearer.getToken()), (KeycloakSecurityContext)session);
        this.completeBearerAuthentication((KeycloakPrincipal<RefreshableKeycloakSecurityContext>)principal, method);
        log.debugv("User ''{0}'' invoking ''{1}'' on client ''{2}''", (Object)principal.getName(), (Object)this.facade.getRequest().getURI(), (Object)this.deployment.getResourceName());
    }
}

